/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="example")
public class ExampleMacro
extends AbstractMacro {
    private static final String XML_CONFIG_START = "/*xml";
    private static final String XML_CONFIG_END = "*/";
    private static final String CODE_SNIPPET_START = "// xdoc section -- start";
    private static final String CODE_SNIPPET_END = "// xdoc section -- end";
    private static final Pattern XML_PATTERN = Pattern.compile("^\\s*(<!DOCTYPE\\s+.*?>|<\\?xml\\s+.*?>|<module\\s+.*?>)\\s*", 32);
    private String lastPath = "";
    private List<String> lastLines = new ArrayList<String>();

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        String path = (String)request.getParameter("path");
        String type = (String)request.getParameter("type");
        List<String> lines = this.lastLines;
        if (!path.equals(this.lastPath)) {
            lines = ExampleMacro.readFile("src/xdocs-examples/" + path);
            this.lastPath = path;
            this.lastLines = lines;
        }
        if ("config".equals(type)) {
            String config = ExampleMacro.getConfigSnippet(lines);
            if (config.isBlank()) {
                String message = String.format(Locale.ROOT, "Empty config snippet from %s, check for xml config snippet delimiters in input file.", path);
                throw new MacroExecutionException(message);
            }
            ExampleMacro.writeSnippet(sink, config);
        } else if ("code".equals(type)) {
            String code = ExampleMacro.getCodeSnippet(lines);
            if (path.contains("filetabcharacter")) {
                code = code.replace("\t", "  ");
            }
            if (code.isBlank()) {
                String message = String.format(Locale.ROOT, "Empty code snippet from %s, check for code snippet delimiters in input file.", path);
                throw new MacroExecutionException(message);
            }
            ExampleMacro.writeSnippet(sink, code);
        } else if ("raw".equals(type)) {
            String content = String.join((CharSequence)ModuleJavadocParsingUtil.NEWLINE, lines);
            ExampleMacro.writeSnippet(sink, content);
        } else {
            String message = String.format(Locale.ROOT, "Unknown example type: %s", type);
            throw new MacroExecutionException(message);
        }
    }

    private static List<String> readFile(String path) throws MacroExecutionException {
        try {
            Path exampleFilePath = Path.of(path, new String[0]);
            return Files.readAllLines(exampleFilePath);
        }
        catch (IOException ioException) {
            String message = String.format(Locale.ROOT, "Failed to read %s", path);
            throw new MacroExecutionException(message, (Throwable)ioException);
        }
    }

    private static String getConfigSnippet(Collection<String> lines) {
        String snippet = lines.stream().dropWhile(line -> !XML_CONFIG_START.equals(line)).skip(1L).takeWhile(line -> !XML_CONFIG_END.equals(line)).collect(Collectors.joining(ModuleJavadocParsingUtil.NEWLINE));
        String result = snippet.isBlank() ? String.join((CharSequence)ModuleJavadocParsingUtil.NEWLINE, lines) : snippet;
        return result;
    }

    private static String getCodeSnippet(Collection<String> lines) {
        ArrayList<String> linesList;
        int configEndIndex;
        String snippet = lines.stream().dropWhile(line -> !line.contains(CODE_SNIPPET_START)).skip(1L).takeWhile(line -> !line.contains(CODE_SNIPPET_END)).collect(Collectors.joining(ModuleJavadocParsingUtil.NEWLINE));
        String result = snippet.isBlank() ? ((configEndIndex = (linesList = new ArrayList<String>(lines)).indexOf(XML_CONFIG_END)) >= 0 ? String.join((CharSequence)ModuleJavadocParsingUtil.NEWLINE, linesList.stream().skip(configEndIndex + 1).toList()) : String.join((CharSequence)ModuleJavadocParsingUtil.NEWLINE, linesList)) : snippet;
        return result;
    }

    private static void writeSnippet(Sink sink, String snippet) {
        sink.rawText("<div class=\"wrapper\">");
        boolean isXml = ExampleMacro.isXml(snippet);
        String languageClass = isXml ? "language-xml" : "language-java";
        sink.rawText("<pre class=\"prettyprint\"><code class=\"" + languageClass + "\">" + ModuleJavadocParsingUtil.NEWLINE);
        sink.rawText(ExampleMacro.escapeHtml(snippet).trim() + ModuleJavadocParsingUtil.NEWLINE);
        sink.rawText("</code></pre>");
        sink.rawText("</div>");
    }

    private static String escapeHtml(String snippet) {
        return snippet.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }

    private static boolean isXml(String snippet) {
        return XML_PATTERN.matcher(snippet.trim()).matches();
    }
}

