/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.filters;

import com.puppycrawl.tools.checkstyle.AbstractAutomaticBean;
import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.TreeWalkerAuditEvent;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.WeakReferenceHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class SuppressionCommentFilter
extends AbstractAutomaticBean
implements TreeWalkerFilter {
    private static final String DEFAULT_OFF_FORMAT = "CHECKSTYLE:OFF";
    private static final String DEFAULT_ON_FORMAT = "CHECKSTYLE:ON";
    private static final String DEFAULT_CHECK_FORMAT = ".*";
    private final List<Tag> tags = new ArrayList<Tag>();
    private final WeakReferenceHolder<FileContents> fileContentsHolder = new WeakReferenceHolder();
    private boolean checkC = true;
    private boolean checkCPP = true;
    private Pattern offCommentFormat = Pattern.compile("CHECKSTYLE:OFF");
    private Pattern onCommentFormat = Pattern.compile("CHECKSTYLE:ON");
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String checkFormat = ".*";
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String messageFormat;
    @XdocsPropertyType(value=PropertyType.PATTERN)
    private String idFormat;

    public final void setOffCommentFormat(Pattern pattern) {
        this.offCommentFormat = pattern;
    }

    public final void setOnCommentFormat(Pattern pattern) {
        this.onCommentFormat = pattern;
    }

    public final void setCheckFormat(String format) {
        this.checkFormat = format;
    }

    public void setMessageFormat(String format) {
        this.messageFormat = format;
    }

    public void setIdFormat(String format) {
        this.idFormat = format;
    }

    public void setCheckCPP(boolean checkCppComments) {
        this.checkCPP = checkCppComments;
    }

    public void setCheckC(boolean checkC) {
        this.checkC = checkC;
    }

    @Override
    protected void finishLocalSetup() {
    }

    @Override
    public boolean accept(TreeWalkerAuditEvent event) {
        boolean accepted = true;
        if (event.violation() != null) {
            FileContents currentContents = event.fileContents();
            this.fileContentsHolder.lazyUpdate(currentContents, this::tagSuppressions);
            Tag matchTag = this.findNearestMatch(event);
            accepted = matchTag == null || matchTag.getTagType() == TagType.ON;
        }
        return accepted;
    }

    private Tag findNearestMatch(TreeWalkerAuditEvent event) {
        Tag result = null;
        for (Tag tag : this.tags) {
            int eventLine = event.getLine();
            if (tag.getLine() > eventLine || tag.getLine() == eventLine && tag.getColumn() > event.getColumn()) break;
            if (!tag.isMatch(event)) continue;
            result = tag;
        }
        return result;
    }

    private void tagSuppressions() {
        this.tags.clear();
        FileContents contents = this.fileContentsHolder.get();
        if (this.checkCPP) {
            this.tagSuppressions(contents.getSingleLineComments().values());
        }
        if (this.checkC) {
            Collection<List<TextBlock>> cComments = contents.getBlockComments().values();
            cComments.forEach(this::tagSuppressions);
        }
        Collections.sort(this.tags);
    }

    private void tagSuppressions(Collection<TextBlock> comments) {
        for (TextBlock comment : comments) {
            int startLineNo = comment.getStartLineNo();
            String[] text = comment.getText();
            this.tagCommentLine(text[0], startLineNo, comment.getStartColNo());
            for (int i = 1; i < text.length; ++i) {
                this.tagCommentLine(text[i], startLineNo + i, 0);
            }
        }
    }

    private void tagCommentLine(String text, int line, int column) {
        Matcher offMatcher = this.offCommentFormat.matcher(text);
        if (offMatcher.find()) {
            this.addTag(offMatcher.group(0), line, column, TagType.OFF);
        } else {
            Matcher onMatcher = this.onCommentFormat.matcher(text);
            if (onMatcher.find()) {
                this.addTag(onMatcher.group(0), line, column, TagType.ON);
            }
        }
    }

    private void addTag(String text, int line, int column, TagType reportingOn) {
        Tag tag = new Tag(line, column, text, reportingOn, this);
        this.tags.add(tag);
    }

    private static final class Tag
    implements Comparable<Tag> {
        private final String text;
        private final int line;
        private final int column;
        private final TagType tagType;
        private final Pattern tagCheckRegexp;
        private final Pattern tagMessageRegexp;
        private final Pattern tagIdRegexp;

        private Tag(int line, int column, String text, TagType tagType, SuppressionCommentFilter filter) {
            this.line = line;
            this.column = column;
            this.text = text;
            this.tagType = tagType;
            Pattern commentFormat = this.tagType == TagType.ON ? filter.onCommentFormat : filter.offCommentFormat;
            String format = "";
            try {
                format = CommonUtil.fillTemplateWithStringsByRegexp(filter.checkFormat, text, commentFormat);
                this.tagCheckRegexp = Pattern.compile(format);
                if (filter.messageFormat == null) {
                    this.tagMessageRegexp = null;
                } else {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.messageFormat, text, commentFormat);
                    this.tagMessageRegexp = Pattern.compile(format);
                }
                if (filter.idFormat == null) {
                    this.tagIdRegexp = null;
                } else {
                    format = CommonUtil.fillTemplateWithStringsByRegexp(filter.idFormat, text, commentFormat);
                    this.tagIdRegexp = Pattern.compile(format);
                }
            }
            catch (PatternSyntaxException exc) {
                throw new IllegalArgumentException("unable to parse expanded comment " + format, exc);
            }
        }

        int getLine() {
            return this.line;
        }

        int getColumn() {
            return this.column;
        }

        TagType getTagType() {
            return this.tagType;
        }

        @Override
        public int compareTo(Tag object) {
            int result = this.line == object.line ? Integer.compare(this.column, object.column) : Integer.compare(this.line, object.line);
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Tag tag = (Tag)other;
            return Objects.equals(this.line, tag.line) && Objects.equals(this.column, tag.column) && Objects.equals((Object)this.tagType, (Object)tag.tagType) && Objects.equals(this.text, tag.text) && Objects.equals(this.tagCheckRegexp, tag.tagCheckRegexp) && Objects.equals(this.tagMessageRegexp, tag.tagMessageRegexp) && Objects.equals(this.tagIdRegexp, tag.tagIdRegexp);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.text, this.line, this.column, this.tagType, this.tagCheckRegexp, this.tagMessageRegexp, this.tagIdRegexp});
        }

        boolean isMatch(TreeWalkerAuditEvent event) {
            return this.isCheckMatch(event) && this.isIdMatch(event) && this.isMessageMatch(event);
        }

        private boolean isCheckMatch(TreeWalkerAuditEvent event) {
            Matcher checkMatcher = this.tagCheckRegexp.matcher(event.getSourceName());
            return checkMatcher.find();
        }

        private boolean isIdMatch(TreeWalkerAuditEvent event) {
            boolean match = true;
            if (this.tagIdRegexp != null) {
                if (event.getModuleId() == null) {
                    match = false;
                } else {
                    Matcher idMatcher = this.tagIdRegexp.matcher(event.getModuleId());
                    match = idMatcher.find();
                }
            }
            return match;
        }

        private boolean isMessageMatch(TreeWalkerAuditEvent event) {
            boolean match = true;
            if (this.tagMessageRegexp != null) {
                Matcher messageMatcher = this.tagMessageRegexp.matcher(event.getMessage());
                match = messageMatcher.find();
            }
            return match;
        }

        public String toString() {
            return "Tag[text='" + this.text + "', line=" + this.line + ", column=" + this.column + ", type=" + String.valueOf((Object)this.tagType) + ", tagCheckRegexp=" + String.valueOf(this.tagCheckRegexp) + ", tagMessageRegexp=" + String.valueOf(this.tagMessageRegexp) + ", tagIdRegexp=" + String.valueOf(this.tagIdRegexp) + "]";
        }
    }

    public static enum TagType {
        ON,
        OFF;

    }
}

