/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Set;
import javax.annotation.Nullable;

@StatelessCheck
public class JavadocParagraphCheck
extends AbstractJavadocCheck {
    public static final String MSG_TAG_AFTER = "javadoc.paragraph.tag.after";
    public static final String MSG_LINE_BEFORE = "javadoc.paragraph.line.before";
    public static final String MSG_REDUNDANT_PARAGRAPH = "javadoc.paragraph.redundant.paragraph";
    public static final String MSG_MISPLACED_TAG = "javadoc.paragraph.misplaced.tag";
    public static final String MSG_PRECEDED_BLOCK_TAG = "javadoc.paragraph.preceded.block.tag";
    private static final String PARAGRAPH_TAG = "p";
    private static final Set<String> BLOCK_TAGS = Set.of("address", "blockquote", "div", "dl", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "ol", "p", "pre", "table", "ul");
    private boolean allowNewlineParagraph = true;

    public void setAllowNewlineParagraph(boolean value) {
        this.allowNewlineParagraph = value;
    }

    @Override
    public int[] getDefaultJavadocTokens() {
        return new int[]{3, 68};
    }

    @Override
    public int[] getRequiredJavadocTokens() {
        return this.getAcceptableJavadocTokens();
    }

    @Override
    public void visitJavadocToken(DetailNode ast) {
        if (ast.getType() == 3 && JavadocParagraphCheck.isEmptyLine(ast)) {
            this.checkEmptyLine(ast);
        } else if (JavadocUtil.isTag(ast, PARAGRAPH_TAG)) {
            this.checkParagraphTag(ast);
        }
    }

    private void checkEmptyLine(DetailNode newline) {
        DetailNode nearestToken = JavadocParagraphCheck.getNearestNode(newline);
        if (nearestToken != null && nearestToken.getType() == 4 && !CommonUtil.isBlank(nearestToken.getText())) {
            this.log(newline.getLineNumber(), newline.getColumnNumber(), MSG_TAG_AFTER, new Object[0]);
        }
    }

    private void checkParagraphTag(DetailNode tag) {
        if (!JavadocParagraphCheck.isNestedParagraph(tag) && !JavadocParagraphCheck.isInsideBlockTag(tag)) {
            DetailNode newLine = JavadocParagraphCheck.getNearestEmptyLine(tag);
            if (JavadocParagraphCheck.isFirstParagraph(tag)) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_REDUNDANT_PARAGRAPH, new Object[0]);
            } else if (newLine == null || tag.getLineNumber() - newLine.getLineNumber() != 1) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_LINE_BEFORE, new Object[0]);
            }
            String blockTagName = JavadocParagraphCheck.findFollowedBlockTagName(tag);
            if (blockTagName != null) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_PRECEDED_BLOCK_TAG, blockTagName);
            }
            if (!this.allowNewlineParagraph && JavadocParagraphCheck.isImmediatelyFollowedByNewLine(tag)) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_MISPLACED_TAG, new Object[0]);
            }
            if (JavadocParagraphCheck.isImmediatelyFollowedByText(tag)) {
                this.log(tag.getLineNumber(), tag.getColumnNumber(), MSG_MISPLACED_TAG, new Object[0]);
            }
        }
    }

    private static boolean isNestedParagraph(DetailNode tag) {
        boolean nested = false;
        for (DetailNode parent = tag.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getType() != 68) continue;
            nested = true;
            break;
        }
        return nested;
    }

    private static boolean isInsideBlockTag(DetailNode tag) {
        boolean result = false;
        for (DetailNode parent = tag; parent != null; parent = parent.getParent()) {
            if (parent.getType() != 75) continue;
            result = true;
            break;
        }
        return result;
    }

    @Nullable
    private static String findFollowedBlockTagName(DetailNode tag) {
        DetailNode htmlElement = JavadocParagraphCheck.findFirstHtmlElementAfter(tag);
        String blockTagName = null;
        if (htmlElement != null) {
            blockTagName = JavadocParagraphCheck.getHtmlElementName(htmlElement);
        }
        return blockTagName;
    }

    @Nullable
    private static DetailNode findFirstHtmlElementAfter(DetailNode tag) {
        DetailNode htmlElement = JavadocParagraphCheck.getNextSibling(tag);
        while (htmlElement != null && htmlElement.getType() != 68) {
            if (htmlElement.getType() == 70) {
                htmlElement = htmlElement.getFirstChild();
                continue;
            }
            if (htmlElement.getType() == 4 && !CommonUtil.isBlank(htmlElement.getText())) {
                htmlElement = null;
                break;
            }
            htmlElement = htmlElement.getNextSibling();
        }
        if (htmlElement != null && JavadocUtil.findFirstToken(htmlElement, 72) == null) {
            htmlElement = null;
        }
        return htmlElement;
    }

    @Nullable
    private static String getHtmlElementName(DetailNode htmlElement) {
        DetailNode htmlTagStart = htmlElement.getFirstChild();
        DetailNode htmlTagName = JavadocUtil.findFirstToken(htmlTagStart, 26);
        String blockTagName = null;
        if (BLOCK_TAGS.contains(htmlTagName.getText())) {
            blockTagName = htmlTagName.getText();
        }
        return blockTagName;
    }

    private static DetailNode getNearestNode(DetailNode node) {
        DetailNode currentNode;
        for (currentNode = node; currentNode != null && (currentNode.getType() == 2 || currentNode.getType() == 3); currentNode = currentNode.getNextSibling()) {
        }
        if (currentNode != null && currentNode.getType() == 70) {
            currentNode = currentNode.getFirstChild();
        }
        return currentNode;
    }

    private static boolean isEmptyLine(DetailNode newLine) {
        boolean result = false;
        DetailNode previousSibling = newLine.getPreviousSibling();
        if (previousSibling != null && (previousSibling.getParent().getType() == 1 || JavadocParagraphCheck.insideNonTightHtml(previousSibling))) {
            if (previousSibling.getType() == 4 && CommonUtil.isBlank(previousSibling.getText())) {
                previousSibling = previousSibling.getPreviousSibling();
            }
            result = previousSibling != null && previousSibling.getType() == 2;
        }
        return result;
    }

    private static boolean insideNonTightHtml(DetailNode previousSibling) {
        DetailNode parent;
        DetailNode htmlElement = parent = previousSibling.getParent();
        if (parent.getType() == 70) {
            htmlElement = parent.getParent();
        }
        return htmlElement.getType() == 68 && JavadocUtil.findFirstToken(htmlElement, 72) == null;
    }

    private static boolean isFirstParagraph(DetailNode paragraphTag) {
        boolean result = true;
        for (DetailNode previousNode = paragraphTag.getPreviousSibling(); previousNode != null; previousNode = previousNode.getPreviousSibling()) {
            if ((previousNode.getType() != 4 || CommonUtil.isBlank(previousNode.getText())) && (previousNode.getType() == 2 || previousNode.getType() == 3 || previousNode.getType() == 4)) continue;
            result = false;
            break;
        }
        return result;
    }

    private static DetailNode getNearestEmptyLine(DetailNode node) {
        DetailNode newLine = node;
        while (newLine != null) {
            DetailNode previousSibling = newLine.getPreviousSibling();
            if (newLine.getType() == 3 && JavadocParagraphCheck.isEmptyLine(newLine)) break;
            newLine = previousSibling;
        }
        return newLine;
    }

    private static boolean isImmediatelyFollowedByText(DetailNode tag) {
        DetailNode nextSibling = JavadocParagraphCheck.getNextSibling(tag);
        return nextSibling == null || nextSibling.getText().startsWith(" ");
    }

    private static boolean isImmediatelyFollowedByNewLine(DetailNode tag) {
        DetailNode sibling = JavadocParagraphCheck.getNextSibling(tag);
        return sibling != null && sibling.getType() == 3;
    }

    private static DetailNode getNextSibling(DetailNode tag) {
        DetailNode paragraphStartTagToken = tag.getFirstChild();
        DetailNode nextNode = paragraphStartTagToken.getNextSibling();
        DetailNode nextSibling = nextNode == null ? tag.getNextSibling() : (nextNode.getType() == 70 ? nextNode.getFirstChild() : nextNode);
        if (nextSibling != null && nextSibling.getType() == 106) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }
}

