/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.FileStatefulCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@FileStatefulCheck
public final class ModifiedControlVariableCheck
extends AbstractCheck {
    public static final String MSG_KEY = "modified.control.variable";
    private static final String ILLEGAL_TYPE_OF_TOKEN = "Illegal type of token: ";
    private static final BitSet MUTATION_OPERATIONS = TokenUtil.asBitSet(25, 26, 130, 129, 80);
    private final Deque<Deque<String>> variableStack = new ArrayDeque<Deque<String>>();
    private boolean skipEnhancedForLoopVariable;

    public void setSkipEnhancedForLoopVariable(boolean skipEnhancedForLoopVariable) {
        this.skipEnhancedForLoopVariable = skipEnhancedForLoopVariable;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{6, 91, 37, 156, 80, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 129, 25, 130, 26};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        this.variableStack.clear();
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 6: {
                this.enterBlock();
                break;
            }
            case 37: 
            case 91: 
            case 156: {
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                this.checkIdent(ast);
                break;
            }
            default: {
                throw new IllegalStateException(ILLEGAL_TYPE_OF_TOKEN + String.valueOf(ast));
            }
        }
    }

    @Override
    public void leaveToken(DetailAST ast) {
        switch (ast.getType()) {
            case 37: {
                this.leaveForIter(ast.getParent());
                break;
            }
            case 156: {
                if (this.skipEnhancedForLoopVariable) break;
                DetailAST paramDef = ast.findFirstToken(10);
                this.leaveForEach(paramDef);
                break;
            }
            case 91: {
                this.leaveForDef(ast);
                break;
            }
            case 6: {
                this.exitBlock();
                break;
            }
            case 25: 
            case 26: 
            case 80: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 129: 
            case 130: {
                break;
            }
            default: {
                throw new IllegalStateException(ILLEGAL_TYPE_OF_TOKEN + String.valueOf(ast));
            }
        }
    }

    private void enterBlock() {
        this.variableStack.push(new ArrayDeque());
    }

    private void exitBlock() {
        this.variableStack.pop();
    }

    private Deque<String> getCurrentVariables() {
        return this.variableStack.peek();
    }

    private void checkIdent(DetailAST ast) {
        Deque<String> currentVariables = this.getCurrentVariables();
        DetailAST identAST = ast.getFirstChild();
        if (identAST != null && identAST.getType() == 58 && currentVariables.contains(identAST.getText())) {
            this.log(ast, MSG_KEY, identAST.getText());
        }
    }

    private void leaveForIter(DetailAST ast) {
        Set<String> variablesToPutInScope = ModifiedControlVariableCheck.getVariablesManagedByForLoop(ast);
        for (String variableName : variablesToPutInScope) {
            this.getCurrentVariables().push(variableName);
        }
    }

    private static Set<String> getVariablesManagedByForLoop(DetailAST ast) {
        Set<String> initializedVariables = ModifiedControlVariableCheck.getForInitVariables(ast);
        Set<String> iteratingVariables = ModifiedControlVariableCheck.getForIteratorVariables(ast);
        return initializedVariables.stream().filter(iteratingVariables::contains).collect(Collectors.toUnmodifiableSet());
    }

    private void leaveForEach(DetailAST paramDef) {
        boolean isRecordPattern;
        boolean bl = isRecordPattern = paramDef == null;
        if (!isRecordPattern) {
            DetailAST paramName = paramDef.findFirstToken(58);
            this.getCurrentVariables().push(paramName.getText());
        }
    }

    private void leaveForDef(DetailAST ast) {
        DetailAST forInitAST = ast.findFirstToken(35);
        if (forInitAST == null) {
            Deque<String> currentVariables = this.getCurrentVariables();
            if (!this.skipEnhancedForLoopVariable && !currentVariables.isEmpty()) {
                currentVariables.pop();
            }
        } else {
            Set<String> variablesManagedByForLoop = ModifiedControlVariableCheck.getVariablesManagedByForLoop(ast);
            this.popCurrentVariables(variablesManagedByForLoop.size());
        }
    }

    private void popCurrentVariables(int count) {
        for (int i = 0; i < count; ++i) {
            this.getCurrentVariables().pop();
        }
    }

    private static Set<String> getForInitVariables(DetailAST ast) {
        HashSet<String> initializedVariables = new HashSet<String>();
        DetailAST forInitAST = ast.findFirstToken(35);
        for (DetailAST parameterDefAST = forInitAST.findFirstToken(10); parameterDefAST != null; parameterDefAST = parameterDefAST.getNextSibling()) {
            if (parameterDefAST.getType() != 10) continue;
            DetailAST param = parameterDefAST.findFirstToken(58);
            initializedVariables.add(param.getText());
        }
        return initializedVariables;
    }

    private static Set<String> getForIteratorVariables(DetailAST ast) {
        HashSet<String> iteratorVariables = new HashSet<String>();
        DetailAST forIteratorAST = ast.findFirstToken(37);
        DetailAST forUpdateListAST = forIteratorAST.findFirstToken(34);
        ModifiedControlVariableCheck.findChildrenOfExpressionType(forUpdateListAST).stream().filter(iteratingExpressionAST -> MUTATION_OPERATIONS.get(iteratingExpressionAST.getType())).forEach(iteratingExpressionAST -> {
            DetailAST oneVariableOperatorChild = iteratingExpressionAST.getFirstChild();
            iteratorVariables.add(oneVariableOperatorChild.getText());
        });
        return iteratorVariables;
    }

    private static List<DetailAST> findChildrenOfExpressionType(DetailAST ast) {
        ArrayList<DetailAST> foundExpressions = new ArrayList<DetailAST>();
        if (ast != null) {
            for (DetailAST iteratingExpressionAST = ast.findFirstToken(28); iteratingExpressionAST != null; iteratingExpressionAST = iteratingExpressionAST.getNextSibling()) {
                if (iteratingExpressionAST.getType() != 28) continue;
                foundExpressions.add(iteratingExpressionAST.getFirstChild());
            }
        }
        return foundExpressions;
    }
}

