/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.annotation;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.AnnotationUtil;
import java.util.HashSet;
import java.util.Set;

@StatelessCheck
public class MissingOverrideOnRecordAccessorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "annotation.missing.override.record.accessor";

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{9};
    }

    @Override
    public void visitToken(DetailAST ast) {
        if (MissingOverrideOnRecordAccessorCheck.isRecordAccessorMethod(ast) && !AnnotationUtil.hasOverrideAnnotation(ast)) {
            this.log(ast, MSG_KEY, new Object[0]);
        }
    }

    private static boolean isRecordAccessorMethod(DetailAST ast) {
        DetailAST parameters;
        boolean result = false;
        DetailAST grandParent = ast.getParent().getParent();
        if (grandParent.getType() == 199 && (parameters = ast.findFirstToken(20)).getChildCount() == 0) {
            String methodName = ast.findFirstToken(58).getText();
            result = MissingOverrideOnRecordAccessorCheck.getRecordComponentNames(grandParent).contains(methodName);
        }
        return result;
    }

    private static Set<String> getRecordComponentNames(DetailAST recordDef) {
        HashSet<String> names = new HashSet<String>();
        DetailAST recordComponents = recordDef.findFirstToken(201);
        for (DetailAST child = recordComponents.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child.getType() != 202) continue;
            names.add(child.findFirstToken(58).getText());
        }
        return names;
    }
}

