/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.CheckstyleParserErrorStrategy;
import com.puppycrawl.tools.checkstyle.JavadocCommentsAstVisitor;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.grammar.SimpleToken;
import com.puppycrawl.tools.checkstyle.grammar.javadoc.JavadocCommentsLexer;
import com.puppycrawl.tools.checkstyle.grammar.javadoc.JavadocCommentsParser;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import java.util.Set;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class JavadocDetailNodeParser {
    public static final String MSG_JAVADOC_PARSE_RULE_ERROR = "javadoc.parse.rule.error";
    public static final String MSG_UNCLOSED_HTML_TAG = "javadoc.unclosedHtml";
    private static final String JAVADOC_START = "/**";

    public ParseStatus parseJavadocComment(DetailAST javadocCommentAst) {
        int blockCommentLineNumber = javadocCommentAst.getLineNo();
        String javadocComment = JavadocUtil.getJavadocCommentContent(javadocCommentAst);
        ParseStatus result = new ParseStatus();
        DescriptiveErrorListener errorListener = new DescriptiveErrorListener();
        errorListener.setOffset(javadocCommentAst.getLineNo() - 1);
        JavadocCommentsLexer lexer = new JavadocCommentsLexer((CharStream)CharStreams.fromString((String)javadocComment), true);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        tokens.fill();
        Set<SimpleToken> unclosedTags = lexer.getUnclosedTagNameTokens();
        JavadocCommentsParser parser = new JavadocCommentsParser(tokens, unclosedTags);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        parser.setErrorHandler((ANTLRErrorStrategy)new CheckstyleParserErrorStrategy());
        try {
            JavadocCommentsParser.JavadocContext javadoc = parser.javadoc();
            int javadocColumnNumber = javadocCommentAst.getColumnNo() + JAVADOC_START.length();
            JavadocCommentsAstVisitor visitor = new JavadocCommentsAstVisitor(tokens, blockCommentLineNumber, javadocColumnNumber);
            DetailNode tree = (DetailNode)visitor.visit((ParseTree)javadoc);
            result.setTree(tree);
            result.firstNonTightHtmlTag = visitor.getFirstNonTightHtmlTag();
            result.setParseErrorMessage(errorListener.getErrorMessage());
        }
        catch (IllegalArgumentException | ParseCancellationException exc) {
            result.setParseErrorMessage(errorListener.getErrorMessage());
        }
        return result;
    }

    public static class ParseStatus {
        private DetailNode tree;
        private ParseErrorMessage parseErrorMessage;
        private DetailNode firstNonTightHtmlTag;

        public DetailNode getTree() {
            return this.tree;
        }

        public void setTree(DetailNode tree) {
            this.tree = tree;
        }

        public ParseErrorMessage getParseErrorMessage() {
            return this.parseErrorMessage;
        }

        public void setParseErrorMessage(ParseErrorMessage parseErrorMessage) {
            this.parseErrorMessage = parseErrorMessage;
        }

        public boolean isNonTight() {
            return this.firstNonTightHtmlTag != null;
        }

        public DetailNode getFirstNonTightHtmlTag() {
            return this.firstNonTightHtmlTag;
        }
    }

    private static final class DescriptiveErrorListener
    extends BaseErrorListener {
        private int offset;
        private ParseErrorMessage errorMessage;

        private DescriptiveErrorListener() {
        }

        private ParseErrorMessage getErrorMessage() {
            return this.errorMessage;
        }

        void setOffset(int offset) {
            this.offset = offset;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException ex) {
            String target;
            int lineNumber = this.offset + line;
            if (recognizer instanceof JavadocCommentsLexer) {
                JavadocCommentsLexer lexer = (JavadocCommentsLexer)recognizer;
                target = lexer.getPreviousToken().getText();
            } else {
                int ruleIndex = ex.getCtx().getRuleIndex();
                String ruleName = recognizer.getRuleNames()[ruleIndex];
                target = DescriptiveErrorListener.convertUpperCamelToUpperUnderscore(ruleName);
            }
            this.errorMessage = new ParseErrorMessage(lineNumber, JavadocDetailNodeParser.MSG_JAVADOC_PARSE_RULE_ERROR, charPositionInLine, msg, target);
        }

        private static String convertUpperCamelToUpperUnderscore(String text) {
            StringBuilder result = new StringBuilder(20);
            for (int index = 0; index < text.length(); ++index) {
                char letter = text.charAt(index);
                if (Character.isUpperCase(letter)) {
                    result.append('_');
                }
                result.append(Character.toUpperCase(letter));
            }
            return result.toString();
        }
    }

    public static class ParseErrorMessage {
        private final int lineNumber;
        private final String messageKey;
        private final Object[] messageArguments;

        ParseErrorMessage(int lineNumber, String messageKey, Object ... messageArguments) {
            this.lineNumber = lineNumber;
            this.messageKey = messageKey;
            this.messageArguments = (Object[])messageArguments.clone();
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMessageKey() {
            return this.messageKey;
        }

        public Object[] getMessageArguments() {
            return (Object[])this.messageArguments.clone();
        }
    }
}

