/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle;

import com.puppycrawl.tools.checkstyle.JavadocDetailNodeParser;
import com.puppycrawl.tools.checkstyle.LocalizedMessage;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.api.FileText;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.ParserUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;

public final class DetailNodeTreeStringPrinter {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private DetailNodeTreeStringPrinter() {
    }

    public static String printFileAst(File file) throws IOException {
        return DetailNodeTreeStringPrinter.printTree(DetailNodeTreeStringPrinter.parseFile(file), "", "");
    }

    public static DetailNode parseJavadocAsDetailNode(DetailAST blockComment) {
        JavadocDetailNodeParser parser = new JavadocDetailNodeParser();
        JavadocDetailNodeParser.ParseStatus status = parser.parseJavadocComment(blockComment);
        if (status.getParseErrorMessage() != null) {
            throw new IllegalArgumentException(DetailNodeTreeStringPrinter.getParseErrorMessage(status.getParseErrorMessage()));
        }
        return status.getTree();
    }

    private static String getParseErrorMessage(JavadocDetailNodeParser.ParseErrorMessage parseErrorMessage) {
        LocalizedMessage message = new LocalizedMessage("com.puppycrawl.tools.checkstyle.checks.javadoc.messages", DetailNodeTreeStringPrinter.class, parseErrorMessage.getMessageKey(), parseErrorMessage.getMessageArguments());
        return "[ERROR:" + parseErrorMessage.getLineNumber() + "] " + message.getMessage();
    }

    public static String printTree(DetailNode ast, String rootPrefix, String prefix) {
        StringBuilder messageBuilder = new StringBuilder(1024);
        for (DetailNode node = ast; node != null; node = node.getNextSibling()) {
            if (node.getType() == 1) {
                messageBuilder.append(rootPrefix);
            } else {
                messageBuilder.append(prefix);
            }
            messageBuilder.append(DetailNodeTreeStringPrinter.getIndentation(node)).append(JavadocUtil.getTokenName(node.getType())).append(" -> ").append(JavadocUtil.escapeAllControlChars(node.getText())).append(" [").append(node.getLineNumber()).append(':').append(node.getColumnNumber() + 1).append(']').append(LINE_SEPARATOR).append(DetailNodeTreeStringPrinter.printTree(node.getFirstChild(), rootPrefix, prefix));
        }
        return messageBuilder.toString();
    }

    private static String getIndentation(DetailNode node) {
        boolean isLastChild = node.getNextSibling() == null;
        DetailNode currentNode = node;
        StringBuilder indentation = new StringBuilder(1024);
        while (currentNode.getParent() != null) {
            if ((currentNode = currentNode.getParent()).getParent() == null) {
                if (isLastChild) {
                    indentation.append("`--");
                    continue;
                }
                indentation.append("|--");
                continue;
            }
            if (currentNode.getNextSibling() == null) {
                indentation.insert(0, "    ");
                continue;
            }
            indentation.insert(0, "|   ");
        }
        return indentation.toString();
    }

    private static DetailNode parseFile(File file) throws IOException {
        FileText text = new FileText(file, Charset.defaultCharset().name());
        DetailAST comment = ParserUtil.createBlockCommentNode(text.getFullText().toString());
        return DetailNodeTreeStringPrinter.parseJavadocAsDetailNode(comment);
    }
}

