/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.DetailAstImpl;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.AbstractMap;
import java.util.Map;
import org.antlr.v4.runtime.CommonToken;

public final class ParserUtil {
    private static final String JAVADOC_START = "/**";
    private static final String BLOCK_MULTIPLE_COMMENT_BEGIN = "/*";
    private static final String BLOCK_MULTIPLE_COMMENT_END = "*/";

    private ParserUtil() {
    }

    public static DetailAST createBlockCommentNode(String content) {
        DetailAstImpl blockCommentBegin = new DetailAstImpl();
        blockCommentBegin.setType(145);
        blockCommentBegin.setText(BLOCK_MULTIPLE_COMMENT_BEGIN);
        blockCommentBegin.setLineNo(0);
        blockCommentBegin.setColumnNo(-JAVADOC_START.length());
        DetailAstImpl commentContent = new DetailAstImpl();
        commentContent.setType(183);
        commentContent.setText("*" + content);
        commentContent.setLineNo(0);
        commentContent.setColumnNo(-1);
        DetailAstImpl blockCommentEnd = new DetailAstImpl();
        blockCommentEnd.setType(182);
        blockCommentEnd.setText(BLOCK_MULTIPLE_COMMENT_END);
        blockCommentBegin.setFirstChild(commentContent);
        commentContent.setNextSibling(blockCommentEnd);
        return blockCommentBegin;
    }

    public static DetailAST createBlockCommentNode(CommonToken token) {
        DetailAstImpl blockComment = new DetailAstImpl();
        blockComment.initialize(145, BLOCK_MULTIPLE_COMMENT_BEGIN);
        int tokenCharPositionInLine = token.getCharPositionInLine();
        int tokenLine = token.getLine();
        String tokenText = token.getText();
        blockComment.setColumnNo(tokenCharPositionInLine);
        blockComment.setLineNo(tokenLine);
        DetailAstImpl blockCommentContent = new DetailAstImpl();
        blockCommentContent.setType(183);
        blockCommentContent.setColumnNo(tokenCharPositionInLine + 2);
        blockCommentContent.setLineNo(tokenLine);
        blockCommentContent.setText(tokenText);
        DetailAstImpl blockCommentClose = new DetailAstImpl();
        blockCommentClose.initialize(182, BLOCK_MULTIPLE_COMMENT_END);
        Map.Entry<Integer, Integer> linesColumns = ParserUtil.countLinesColumns(tokenText, tokenLine, tokenCharPositionInLine + 1);
        blockCommentClose.setLineNo(linesColumns.getKey());
        blockCommentClose.setColumnNo(linesColumns.getValue());
        blockComment.addChild(blockCommentContent);
        blockComment.addChild(blockCommentClose);
        return blockComment;
    }

    private static Map.Entry<Integer, Integer> countLinesColumns(String text, int initialLinesCnt, int initialColumnsCnt) {
        int lines = initialLinesCnt;
        int columns = initialColumnsCnt;
        boolean foundCr = false;
        for (int index = 0; index < text.length(); ++index) {
            char c = text.charAt(index);
            if (c == '\n') {
                foundCr = false;
                ++lines;
                columns = 0;
                continue;
            }
            if (foundCr) {
                foundCr = false;
                ++lines;
                columns = 0;
            }
            if (c == '\r') {
                foundCr = true;
            }
            ++columns;
        }
        if (foundCr) {
            ++lines;
            columns = 0;
        }
        return new AbstractMap.SimpleEntry<Integer, Integer>(lines, columns);
    }
}

