/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.checks.javadoc.AbstractJavadocCheck;
import com.puppycrawl.tools.checkstyle.meta.ModuleDetails;
import com.puppycrawl.tools.checkstyle.meta.ModulePropertyDetails;
import com.puppycrawl.tools.checkstyle.meta.ModuleType;
import com.puppycrawl.tools.checkstyle.meta.XmlMetaWriter;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.JavadocUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.doxia.macro.MacroExecutionException;

public final class MetadataGeneratorUtil {
    private MetadataGeneratorUtil() {
    }

    public static void generate(String path, String ... moduleFolders) throws IOException, CheckstyleException {
        List<File> modulesToProcess = MetadataGeneratorUtil.getTargetFiles(path, moduleFolders);
        try {
            for (File file : modulesToProcess) {
                String fileName = file.getName();
                if (fileName.startsWith("Abstract") && !"AbstractClassNameCheck.java".equals(fileName)) continue;
                ModuleDetails moduleDetails = MetadataGeneratorUtil.getModuleDetails(file);
                MetadataGeneratorUtil.writeMetadataFile(moduleDetails);
            }
        }
        catch (MacroExecutionException macroException) {
            throw new CheckstyleException("Failed to execute macro", macroException);
        }
    }

    private static ModuleDetails getModuleDetails(File file) throws MacroExecutionException {
        String moduleName = SiteUtil.FINAL_CHECK.matcher(SiteUtil.getModuleName(file)).replaceAll("");
        Object instance = SiteUtil.getModuleInstance(moduleName);
        Class<?> clss = instance.getClass();
        String fullyQualifiedName = clss.getName();
        String parentModule = SiteUtil.getParentModule(clss);
        Object parentModuleInstance = SiteUtil.getModuleInstance(parentModule);
        String parentModuleString = parentModuleInstance.getClass().getName();
        ModuleType moduleType = MetadataGeneratorUtil.getModuleType(moduleName);
        Set<String> messageKeys = SiteUtil.getMessageKeys(clss);
        String className = SiteUtil.getModuleName(file);
        Set<String> properties = SiteUtil.getPropertiesForDocumentation(clss, instance);
        Map<String, DetailNode> propertiesJavadocs = SiteUtil.getPropertiesJavadocs(properties, className, file.toPath());
        DetailNode moduleJavadoc = SiteUtil.getModuleJavadoc(className, file.toPath());
        Object description = ModuleJavadocParsingUtil.getModuleDescription(moduleJavadoc);
        String notes = ModuleJavadocParsingUtil.getModuleNotes(moduleJavadoc);
        if (!notes.isEmpty()) {
            description = (String)description + "\n\n " + notes;
        }
        List<ModulePropertyDetails> propertiesDetails = MetadataGeneratorUtil.getPropertiesDetails(properties, propertiesJavadocs, className, instance);
        return new ModuleDetails(moduleName, fullyQualifiedName, parentModuleString, (String)description, moduleType, propertiesDetails, new ArrayList<String>(messageKeys));
    }

    private static ModuleType getModuleType(String moduleName) {
        ModuleType result = moduleName.endsWith("FileFilter") ? ModuleType.FILEFILTER : (moduleName.endsWith("Filter") ? ModuleType.FILTER : ModuleType.CHECK);
        return result;
    }

    private static List<ModulePropertyDetails> getPropertiesDetails(Set<String> properties, Map<String, DetailNode> javadocs, String className, Object instance) throws MacroExecutionException {
        ArrayList<ModulePropertyDetails> result = new ArrayList<ModulePropertyDetails>(properties.size());
        for (String property : properties) {
            String description = MetadataGeneratorUtil.getPropertyDescription(property, javadocs.get(property));
            Field propertyField = SiteUtil.getField(instance.getClass(), property);
            String type = SiteUtil.getType(propertyField, property, className, instance);
            String defaultValue = MetadataGeneratorUtil.getPropertyDefaultValue(property, propertyField, instance, className);
            String validationType = MetadataGeneratorUtil.getValidationType(property, propertyField);
            result.add(new ModulePropertyDetails(property, type, defaultValue, validationType, description));
        }
        return result;
    }

    private static String getPropertyDefaultValue(String property, Field field, Object instance, String className) throws MacroExecutionException {
        String defaultValue;
        if ("tokens".equals(property)) {
            AbstractCheck check = (AbstractCheck)instance;
            List<String> configurableTokens = SiteUtil.getDifference(check.getDefaultTokens(), check.getRequiredTokens()).stream().map(TokenUtil::getTokenName).toList();
            defaultValue = String.join((CharSequence)",", configurableTokens);
        } else if ("javadocTokens".equals(property)) {
            AbstractJavadocCheck check = (AbstractJavadocCheck)instance;
            List<String> configurableTokens = SiteUtil.getDifference(check.getDefaultJavadocTokens(), check.getRequiredJavadocTokens()).stream().map(JavadocUtil::getTokenName).toList();
            defaultValue = String.join((CharSequence)",", configurableTokens);
        } else {
            defaultValue = SiteUtil.getDefaultValue(property, field, instance, className);
        }
        return defaultValue;
    }

    private static void writeMetadataFile(ModuleDetails moduleDetails) throws CheckstyleException {
        try {
            XmlMetaWriter.write(moduleDetails);
        }
        catch (ParserConfigurationException | TransformerException example) {
            throw new CheckstyleException("Failed to write metadata into XML file for module: " + moduleDetails.getName(), example);
        }
    }

    private static String getValidationType(String propertyName, Field propertyField) {
        String validationType = "tokens".equals(propertyName) || "javadocTokens".equals(propertyName) ? "tokenSet" : (propertyField != null && ModuleJavadocParsingUtil.isPropertySpecialTokenProp(propertyField) ? "tokenTypesSet" : null);
        return validationType;
    }

    private static String getPropertyDescription(String property, DetailNode propertyJavadoc) {
        Object propertyDescription;
        if ("tokens".equals(property)) {
            propertyDescription = "tokens to check";
        } else if ("javadocTokens".equals(property)) {
            propertyDescription = "javadoc tokens to check";
        } else {
            String firstJavadocParagraph = SiteUtil.getFirstParagraphFromJavadoc(propertyJavadoc);
            String setterToString = "Setter to ";
            if (firstJavadocParagraph.contains("Setter to ")) {
                String unprocessedPropertyDescription = firstJavadocParagraph.substring("Setter to ".length());
                String firstLetterCapitalized = unprocessedPropertyDescription.substring(0, 1).toUpperCase(Locale.ROOT);
                propertyDescription = firstLetterCapitalized + unprocessedPropertyDescription.substring(1);
            } else {
                propertyDescription = firstJavadocParagraph;
            }
        }
        return propertyDescription;
    }

    private static List<File> getTargetFiles(String path, String ... moduleFolders) throws IOException {
        ArrayList<File> validFiles = new ArrayList<File>();
        for (String folder : moduleFolders) {
            try (Stream<Path> files = Files.walk(Path.of(path + "/" + folder, new String[0]), new FileVisitOption[0]);){
                validFiles.addAll(files.map(Path::toFile).filter(file -> {
                    String fileName = file.getName();
                    return fileName.endsWith("SuppressWarningsHolder.java") || fileName.endsWith("Check.java") || fileName.endsWith("Filter.java");
                }).toList());
            }
        }
        return validFiles;
    }
}

