/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.DetailAstSet;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;

public class MethodCallHandler
extends AbstractExpressionHandler {
    private final IndentationCheck indentCheck;

    public MethodCallHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "method call", ast, parent);
        this.indentCheck = indentCheck;
    }

    @Override
    protected IndentLevel getIndentImpl() {
        IndentLevel indentLevel;
        AbstractExpressionHandler abstractExpressionHandler = this.getParent();
        if (abstractExpressionHandler instanceof MethodCallHandler) {
            MethodCallHandler container = (MethodCallHandler)abstractExpressionHandler;
            indentLevel = TokenUtil.areOnSameLine(container.getMainAst(), this.getMainAst()) || this.isChainedMethodCallWrapped() || MethodCallHandler.areMethodsChained(container.getMainAst(), this.getMainAst()) ? container.getIndent() : new IndentLevel(container.getIndent(), this.getIndentCheck().getLineWrappingIndentation());
        } else if (this.getMainAst().getFirstChild().getType() == 136) {
            indentLevel = super.getIndentImpl();
        } else {
            DetailAstSet astSet = new DetailAstSet(this.indentCheck);
            this.findSubtreeAst(astSet, this.getMainAst().getFirstChild(), true);
            int firstCol = this.expandedTabsColumnNo(astSet.firstLine());
            int lineStart = this.getLineStart(MethodCallHandler.getFirstAst(this.getMainAst()));
            indentLevel = lineStart == firstCol ? super.getIndentImpl() : new IndentLevel(lineStart);
        }
        return indentLevel;
    }

    private static boolean areMethodsChained(DetailAST ast1, DetailAST ast2) {
        DetailAST rparen = ast1.findFirstToken(77);
        return TokenUtil.areOnSameLine(rparen, ast2);
    }

    private boolean isChainedMethodCallWrapped() {
        DetailAST dot1;
        DetailAST main = this.getMainAst();
        DetailAST dot = main.getFirstChild();
        DetailAST target = dot.getFirstChild();
        DetailAST target1 = dot1 = target.getFirstChild();
        while (target1.getFirstChild() != null && target1.getType() != 27) {
            target1 = target1.getFirstChild();
        }
        return dot1.getType() == 59 && target1.getType() == 27;
    }

    private static DetailAST getFirstAst(DetailAST ast) {
        DetailAST astNode = ast.getFirstChild();
        while (astNode.getType() == 59) {
            astNode = astNode.getFirstChild();
        }
        return astNode;
    }

    private DetailAST getMethodIdentAst() {
        DetailAST ast = this.getMainAst();
        if (ast.getType() != 42 && (ast = ast.getFirstChild()).getType() == 59) {
            ast = ast.getLastChild();
        }
        return ast;
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        DetailAST ident = this.getMethodIdentAst();
        DetailAST rparen = this.getMainAst().findFirstToken(77);
        IndentLevel suggestedLevel = new IndentLevel(this.getLineStart(ident));
        if (!TokenUtil.areOnSameLine(child.getMainAst().getFirstChild(), ident)) {
            suggestedLevel = new IndentLevel(suggestedLevel, this.getBasicOffset(), this.getIndentCheck().getLineWrappingIndentation());
        }
        if (this.getLineStart(rparen) == rparen.getColumnNo()) {
            suggestedLevel = IndentLevel.addAcceptable(suggestedLevel, new IndentLevel(this.getParent().getSuggestedChildIndent(this), this.getIndentCheck().getLineWrappingIndentation()));
        }
        return suggestedLevel;
    }

    @Override
    public void checkIndentation() {
        DetailAST lparen = null;
        if (this.getMainAst().getType() == 27) {
            DetailAST exprNode = this.getMainAst().getParent();
            if (exprNode.getParent().getType() == 7) {
                this.checkExpressionSubtree(this.getMainAst().getFirstChild(), this.getIndent(), false, false);
                lparen = this.getMainAst();
            }
        } else {
            lparen = this.getMainAst().getFirstChild();
        }
        if (lparen != null) {
            DetailAST rparen = this.getMainAst().findFirstToken(77);
            this.checkLeftParen(lparen);
            if (!TokenUtil.areOnSameLine(rparen, lparen)) {
                this.checkExpressionSubtree(this.getMainAst().findFirstToken(34), new IndentLevel(this.getIndent(), this.getBasicOffset()), false, true);
                this.checkRparenIndent(lparen, rparen);
                this.checkWrappingIndentation(this.getMainAst(), MethodCallHandler.getCallLastNode(this.getMainAst()));
            }
        }
    }

    private void checkRparenIndent(DetailAST lparen, DetailAST rparen) {
        int lineStart;
        IndentLevel standardIndent;
        int rparenLevel = this.expandedTabsColumnNo(rparen);
        int lparenLevel = this.expandedTabsColumnNo(lparen);
        IndentLevel enhancedIndent = standardIndent = this.getIndent();
        if (this.getParent() instanceof MethodCallHandler && (lineStart = this.getLineStart(MethodCallHandler.getFirstAst(this.getMainAst()))) != standardIndent.getFirstIndentLevel()) {
            enhancedIndent = IndentLevel.addAcceptable(standardIndent, new IndentLevel(lineStart));
        }
        if (rparenLevel != lparenLevel + 1 && !enhancedIndent.isAcceptable(rparenLevel) && this.isOnStartOfLine(rparen)) {
            this.logError(rparen, "rparen", rparenLevel);
        }
    }

    @Override
    protected boolean shouldIncreaseIndent() {
        return false;
    }

    private static DetailAST getCallLastNode(DetailAST firstNode) {
        return firstNode.getLastChild();
    }
}

