/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import com.puppycrawl.tools.checkstyle.checks.naming.AccessModifierOption;
import com.puppycrawl.tools.checkstyle.utils.CheckUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.UnmodifiableCollectionUtil;
import java.util.Arrays;
import java.util.regex.Pattern;

@StatelessCheck
public class JavadocVariableCheck
extends AbstractCheck {
    public static final String MSG_JAVADOC_MISSING = "javadoc.missing";
    private AccessModifierOption[] accessModifiers = new AccessModifierOption[]{AccessModifierOption.PUBLIC, AccessModifierOption.PROTECTED, AccessModifierOption.PACKAGE, AccessModifierOption.PRIVATE};
    private Pattern ignoreNamePattern;

    public void setAccessModifiers(AccessModifierOption ... accessModifiers) {
        this.accessModifiers = UnmodifiableCollectionUtil.copyOfArray(accessModifiers, accessModifiers.length);
    }

    public void setIgnoreNamePattern(Pattern pattern) {
        this.ignoreNamePattern = pattern;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{10, 155};
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{10};
    }

    @Override
    public void visitToken(DetailAST ast) {
        FileContents contents;
        TextBlock textBlock;
        if (this.shouldCheck(ast) && (textBlock = (contents = this.getFileContents()).getJavadocBefore(ast.getLineNo())) == null) {
            this.log(ast, MSG_JAVADOC_MISSING, new Object[0]);
        }
    }

    private boolean isIgnored(DetailAST ast) {
        String name = ast.findFirstToken(58).getText();
        return this.ignoreNamePattern != null && this.ignoreNamePattern.matcher(name).matches() || "serialVersionUID".equals(name);
    }

    private boolean matchAccessModifiers(AccessModifierOption accessModifier) {
        return Arrays.stream(this.accessModifiers).anyMatch(modifier -> modifier == accessModifier);
    }

    private boolean shouldCheck(DetailAST ast) {
        boolean result = false;
        if (!ScopeUtil.isInCodeBlock(ast) && !this.isIgnored(ast)) {
            AccessModifierOption accessModifier = JavadocVariableCheck.getAccessModifierFromModifiersTokenWithPrivateEnumSupport(ast);
            result = this.matchAccessModifiers(accessModifier);
        }
        return result;
    }

    public static AccessModifierOption getAccessModifierFromModifiersTokenWithPrivateEnumSupport(DetailAST ast) {
        DetailAST selectedAst = ast;
        if (selectedAst.getType() == 155) {
            while (selectedAst.getType() != 154) {
                selectedAst = selectedAst.getParent();
            }
        }
        return CheckUtil.getAccessModifierFromModifiersToken(selectedAst);
    }
}

