/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.api.DetailNode;
import com.puppycrawl.tools.checkstyle.site.ModuleJavadocParsingUtil;
import com.puppycrawl.tools.checkstyle.site.SiteUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.nio.file.Path;
import java.util.regex.Pattern;
import org.apache.maven.doxia.macro.AbstractMacro;
import org.apache.maven.doxia.macro.Macro;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=Macro.class, hint="checks")
public class ChecksXmlMacro
extends AbstractMacro {
    private static final Pattern STRUCTURAL_TAG_PATTERN = Pattern.compile("(?is)</?(?:div|p|span|em|strong)[^>]*>");
    private static final Pattern ANCHOR_TAG_PATTERN = Pattern.compile("(?is)<a[^>]*?>|</a>");
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    public void execute(Sink sink, MacroRequest request) throws MacroExecutionException {
        Object param = request.getParameter("modulePath");
        if (param == null) {
            throw new MacroExecutionException("Parameter 'modulePath' is required.");
        }
        Path modulePath = Path.of((String)param, new String[0]);
        String moduleName = CommonUtil.getFileNameWithoutExtension(modulePath.toString());
        DetailNode moduleJavadoc = SiteUtil.getModuleJavadoc(moduleName, modulePath);
        if (moduleJavadoc == null) {
            throw new MacroExecutionException("Javadoc of module " + moduleName + " not found.");
        }
        String moduleDescription = ModuleJavadocParsingUtil.getModuleDescription(moduleJavadoc);
        String cleanDescription = ChecksXmlMacro.sanitize(moduleDescription);
        String summarySentence = ChecksXmlMacro.extractFirstSentence(cleanDescription);
        String textToWrap = summarySentence.trim();
        String formatted = ChecksXmlMacro.wrapText(textToWrap, 70);
        sink.rawText(formatted);
    }

    private static String extractFirstSentence(String description) {
        String result = "";
        if (description != null) {
            int endIndex = -1;
            int descriptionLength = description.length();
            for (int index = 0; index < descriptionLength; ++index) {
                if (description.charAt(index) != '.' || index != descriptionLength - 1 && !Character.isWhitespace(description.charAt(index + 1)) && description.charAt(index + 1) != '<') continue;
                endIndex = index;
                break;
            }
            result = endIndex == -1 ? description : description.substring(0, endIndex + 1);
        }
        return result.trim();
    }

    private static String wrapText(String text, int wrapLimit) {
        String result;
        if (text == null || text.isEmpty()) {
            result = "";
        } else {
            StringBuilder wrapped = new StringBuilder(text.length() + 32);
            String remaining = text.trim();
            boolean isFirstLine = true;
            String continuationIndent = ModuleJavadocParsingUtil.INDENT_LEVEL_14;
            int remainingLength = remaining.length();
            while (remainingLength > wrapLimit) {
                int breakIndex = remaining.lastIndexOf(32, wrapLimit);
                if (breakIndex <= 0 || breakIndex > remainingLength) {
                    breakIndex = Math.min(wrapLimit, remainingLength);
                }
                int safeBreakIndex = Math.min(Math.max(0, breakIndex), remainingLength);
                if (!isFirstLine) {
                    wrapped.append(continuationIndent);
                }
                wrapped.append(remaining, 0, safeBreakIndex);
                remaining = remaining.substring(safeBreakIndex).trim();
                remainingLength = remaining.length();
                isFirstLine = false;
            }
            if (!isFirstLine) {
                wrapped.append(continuationIndent);
            }
            wrapped.append(remaining);
            result = wrapped.toString();
        }
        return result;
    }

    private static String sanitize(String html) {
        String result;
        if (html == null || html.isEmpty()) {
            result = "";
        } else {
            String cleaned = ANCHOR_TAG_PATTERN.matcher(html).replaceAll("");
            cleaned = STRUCTURAL_TAG_PATTERN.matcher(cleaned).replaceAll("");
            cleaned = SPACE_PATTERN.matcher(cleaned).replaceAll(" ");
            result = cleaned.trim();
        }
        return result;
    }
}

