/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.meta;

import com.puppycrawl.tools.checkstyle.meta.ModuleDetails;
import com.puppycrawl.tools.checkstyle.meta.ModulePropertyDetails;
import com.puppycrawl.tools.checkstyle.meta.ModuleType;
import java.io.File;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class XmlMetaWriter {
    private static final Pattern FILEPATH_CONVERSION = Pattern.compile("\\.");
    private static final String XML_TAG_NAME = "name";
    private static final String XML_TAG_DESCRIPTION = "description";
    private static final String DEFAULT_FILE_SEPARATOR = "/";

    private XmlMetaWriter() {
    }

    public static void write(ModuleDetails moduleDetails) throws TransformerException, ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        dbFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document doc = dBuilder.newDocument();
        Element rootElement = doc.createElement("checkstyle-metadata");
        Element rootChild = doc.createElement("module");
        rootElement.appendChild(rootChild);
        doc.appendChild(rootElement);
        Element checkModule = doc.createElement(moduleDetails.getModuleType().getLabel());
        rootChild.appendChild(checkModule);
        checkModule.setAttribute(XML_TAG_NAME, moduleDetails.getName());
        checkModule.setAttribute("fully-qualified-name", moduleDetails.getFullQualifiedName());
        checkModule.setAttribute("parent", moduleDetails.getParent());
        Element desc = doc.createElement(XML_TAG_DESCRIPTION);
        CDATASection cdataDesc = doc.createCDATASection(moduleDetails.getDescription());
        desc.appendChild(cdataDesc);
        checkModule.appendChild(desc);
        XmlMetaWriter.createPropertySection(moduleDetails, checkModule, doc);
        if (!moduleDetails.getViolationMessageKeys().isEmpty()) {
            Element messageKeys = doc.createElement("message-keys");
            for (String msg : moduleDetails.getViolationMessageKeys()) {
                Element messageKey = doc.createElement("message-key");
                messageKey.setAttribute("key", msg);
                messageKeys.appendChild(messageKey);
            }
            checkModule.appendChild(messageKeys);
        }
        XmlMetaWriter.writeToFile(doc, moduleDetails);
    }

    private static void createPropertySection(ModuleDetails moduleDetails, Element checkModule, Document doc) {
        List<ModulePropertyDetails> moduleProperties = moduleDetails.getProperties();
        if (!moduleProperties.isEmpty()) {
            Element properties = doc.createElement("properties");
            checkModule.appendChild(properties);
            for (ModulePropertyDetails modulePropertyDetails : moduleProperties) {
                String validationType;
                Element property = doc.createElement("property");
                properties.appendChild(property);
                property.setAttribute(XML_TAG_NAME, modulePropertyDetails.getName());
                property.setAttribute("type", modulePropertyDetails.getType());
                String defaultValue = modulePropertyDetails.getDefaultValue();
                if (defaultValue != null && !"null".equals(defaultValue)) {
                    property.setAttribute("default-value", defaultValue);
                }
                if ((validationType = modulePropertyDetails.getValidationType()) != null) {
                    property.setAttribute("validation-type", validationType);
                }
                Element propertyDesc = doc.createElement(XML_TAG_DESCRIPTION);
                propertyDesc.appendChild(doc.createCDATASection(modulePropertyDetails.getDescription()));
                property.appendChild(propertyDesc);
            }
        }
    }

    private static void writeToFile(Document document, ModuleDetails moduleDetails) throws TransformerException {
        String modifiedPath;
        Object fileSeparator = DEFAULT_FILE_SEPARATOR;
        if (System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win")) {
            fileSeparator = "\\" + (String)fileSeparator;
        }
        String xmlExtension = ".xml";
        String rootOutputPath = System.getProperty("user.dir") + "/src/main/resources";
        if (moduleDetails.getFullQualifiedName().startsWith("com.puppycrawl.tools.checkstyle")) {
            String moduleFilePath = FILEPATH_CONVERSION.matcher(moduleDetails.getFullQualifiedName()).replaceAll((String)fileSeparator);
            String checkstyleString = "checkstyle";
            int indexOfCheckstyle = moduleFilePath.indexOf("checkstyle") + "checkstyle".length();
            modifiedPath = rootOutputPath + DEFAULT_FILE_SEPARATOR + moduleFilePath.substring(0, indexOfCheckstyle) + "/meta/" + moduleFilePath.substring(indexOfCheckstyle + 1) + ".xml";
        } else {
            Object moduleName = moduleDetails.getName();
            if (moduleDetails.getModuleType() == ModuleType.CHECK) {
                moduleName = (String)moduleName + "Check";
            }
            modifiedPath = rootOutputPath + "/checkstylemeta-" + (String)moduleName + ".xml";
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new File(modifiedPath));
        transformer.transform(source, result);
    }
}

