/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.javadoc;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.Scope;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum JavadocTagInfo {
    AUTHOR("@author", "author", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 16 || TokenUtil.isTypeDeclaration(astType);
        }
    }
    ,
    CODE("{@code}", "code", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    DOC_ROOT("{@docRoot}", "docRoot", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    DEPRECATED("@deprecated", "deprecated", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES_DEPRECATED.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    EXCEPTION("@exception", "exception", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 9 || astType == 8;
        }
    }
    ,
    INHERIT_DOC("{@inheritDoc}", "inheritDoc", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 9 && ast.findFirstToken(5).findFirstToken(64) == null && ScopeUtil.getScope(ast) != Scope.PRIVATE;
        }
    }
    ,
    LINK("{@link}", "link", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    LINKPLAIN("{@linkplain}", "linkplain", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    LITERAL("{@literal}", "literal", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    PARAM("@param", "param", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 14 || astType == 15 || astType == 9 || astType == 8;
        }
    }
    ,
    RETURN("@return", "return", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            DetailAST returnType = ast.findFirstToken(13);
            return astType == 9 && returnType.getFirstChild().getType() != 49;
        }
    }
    ,
    SEE("@see", "see", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    SERIAL("@serial", "serial", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 10 && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    SERIAL_DATA("@serialData", "serialData", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            DetailAST methodNameAst = ast.findFirstToken(58);
            String methodName = methodNameAst.getText();
            return astType == 9 && ("writeObject".equals(methodName) || "readObject".equals(methodName) || "writeExternal".equals(methodName) || "readExternal".equals(methodName) || "writeReplace".equals(methodName) || "readResolve".equals(methodName));
        }
    }
    ,
    SERIAL_FIELD("@serialField", "serialField", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            DetailAST varType = ast.findFirstToken(13);
            return astType == 10 && varType.getFirstChild().getType() == 17 && "ObjectStreamField".equals(varType.getFirstChild().getText());
        }
    }
    ,
    SINCE("@since", "since", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    THROWS("@throws", "throws", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 9 || astType == 8;
        }
    }
    ,
    VALUE("{@value}", "value", Type.INLINE){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return DEF_TOKEN_TYPES.get(astType) && !ScopeUtil.isLocalVariableDef(ast);
        }
    }
    ,
    VERSION("@version", "version", Type.BLOCK){

        @Override
        public boolean isValidOn(DetailAST ast) {
            int astType = ast.getType();
            return astType == 16 || TokenUtil.isTypeDeclaration(astType);
        }
    };

    private static final BitSet DEF_TOKEN_TYPES_DEPRECATED;
    private static final BitSet DEF_TOKEN_TYPES;
    private static final Map<String, JavadocTagInfo> TEXT_TO_TAG;
    private static final Map<String, JavadocTagInfo> NAME_TO_TAG;
    private final String text;
    private final String name;
    private final Type type;

    private JavadocTagInfo(String text, String name, Type type) {
        this.text = text;
        this.name = name;
        this.type = type;
    }

    public abstract boolean isValidOn(DetailAST var1);

    public String getText() {
        return this.text;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public static JavadocTagInfo fromText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("the text is null");
        }
        JavadocTagInfo tag = TEXT_TO_TAG.get(text);
        if (tag == null) {
            throw new IllegalArgumentException("the text [" + text + "] is not a valid Javadoc tag text");
        }
        return tag;
    }

    public static JavadocTagInfo fromName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("the name is null");
        }
        JavadocTagInfo tag = NAME_TO_TAG.get(name);
        if (tag == null) {
            throw new IllegalArgumentException("the name [" + name + "] is not a valid Javadoc tag name");
        }
        return tag;
    }

    public static boolean isValidName(String name) {
        return NAME_TO_TAG.containsKey(name);
    }

    public String toString() {
        return "text [" + this.text + "] name [" + this.name + "] type [" + String.valueOf((Object)this.type) + "]";
    }

    static {
        DEF_TOKEN_TYPES_DEPRECATED = TokenUtil.asBitSet(8, 9, 10, 14, 15, 154, 155, 157, 161);
        DEF_TOKEN_TYPES = TokenUtil.asBitSet(8, 9, 10, 14, 15, 16, 154, 157);
        JavadocTagInfo[] values = JavadocTagInfo.values();
        TEXT_TO_TAG = Arrays.stream(values).collect(Collectors.toUnmodifiableMap(JavadocTagInfo::getText, Function.identity()));
        NAME_TO_TAG = Arrays.stream(values).collect(Collectors.toUnmodifiableMap(JavadocTagInfo::getName, Function.identity()));
    }

    public static enum Type {
        BLOCK,
        INLINE;

    }
}

