/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.header;

import com.puppycrawl.tools.checkstyle.PropertyType;
import com.puppycrawl.tools.checkstyle.XdocsPropertyType;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.ExternalResourceHolder;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public abstract class AbstractHeaderCheck
extends AbstractFileSetCheck
implements ExternalResourceHolder {
    private static final Pattern ESCAPED_LINE_FEED_PATTERN = Pattern.compile("\\\\n");
    private final List<String> readerLines = new ArrayList<String>();
    private URI headerFile;
    @XdocsPropertyType(value=PropertyType.STRING)
    private Charset charset;

    protected abstract void postProcessHeaderLines();

    protected List<String> getHeaderLines() {
        return List.copyOf(this.readerLines);
    }

    public void setCharset(String charset) {
        this.charset = AbstractHeaderCheck.createCharset(charset);
    }

    public void setHeaderFile(URI uri) throws CheckstyleException {
        if (uri == null) {
            throw new CheckstyleException("property 'headerFile' is missing or invalid in module " + this.getConfiguration().getName());
        }
        this.headerFile = uri;
    }

    private void loadHeaderFile() throws CheckstyleException {
        this.checkHeaderNotInitialized();
        try (InputStreamReader headerReader = new InputStreamReader((InputStream)new BufferedInputStream(this.headerFile.toURL().openStream()), this.charset);){
            this.loadHeader(headerReader);
        }
        catch (IOException exc) {
            throw new CheckstyleException("unable to load header file " + String.valueOf(this.headerFile), exc);
        }
    }

    private void checkHeaderNotInitialized() {
        if (!this.readerLines.isEmpty()) {
            throw new IllegalArgumentException("header has already been set - set either header or headerFile, not both");
        }
    }

    private static Charset createCharset(String name) {
        if (!Charset.isSupported(name)) {
            String message = "unsupported charset: '" + name + "'";
            throw new UnsupportedCharsetException(message);
        }
        return Charset.forName(name);
    }

    public void setHeader(String header) {
        if (!CommonUtil.isBlank(header)) {
            this.checkHeaderNotInitialized();
            String headerExpandedNewLines = ESCAPED_LINE_FEED_PATTERN.matcher(header).replaceAll("\n");
            try (StringReader headerReader = new StringReader(headerExpandedNewLines);){
                this.loadHeader(headerReader);
            }
            catch (IOException exc) {
                throw new IllegalArgumentException("unable to load header", exc);
            }
        }
    }

    private void loadHeader(Reader headerReader) throws IOException {
        try (LineNumberReader lnr = new LineNumberReader(headerReader);){
            String line;
            do {
                if ((line = lnr.readLine()) == null) continue;
                this.readerLines.add(line);
            } while (line != null);
            this.postProcessHeaderLines();
        }
    }

    @Override
    protected final void finishLocalSetup() throws CheckstyleException {
        if (this.headerFile != null) {
            this.loadHeaderFile();
        }
    }

    @Override
    public Set<String> getExternalResourceLocations() {
        Set<String> result = this.headerFile == null ? Set.of() : Set.of(this.headerFile.toASCIIString());
        return result;
    }
}

