/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.TokenUtil;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Stream;

@StatelessCheck
public class FallThroughCheck
extends AbstractCheck {
    public static final String MSG_FALL_THROUGH = "fall.through";
    public static final String MSG_FALL_THROUGH_LAST = "fall.through.last";
    private boolean checkLastCaseGroup;
    private Pattern reliefPattern = Pattern.compile("falls?[ -]?thr(u|ough)");

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return new int[]{33};
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public boolean isCommentNodesRequired() {
        return true;
    }

    public void setReliefPattern(Pattern pattern) {
        this.reliefPattern = pattern;
    }

    public void setCheckLastCaseGroup(boolean value) {
        this.checkLastCaseGroup = value;
    }

    @Override
    public void visitToken(DetailAST ast) {
        DetailAST slist;
        boolean isLastGroup;
        DetailAST nextGroup = ast.getNextSibling();
        boolean bl = isLastGroup = nextGroup.getType() != 33;
        if (!(isLastGroup && !this.checkLastCaseGroup || (slist = ast.findFirstToken(7)) == null || this.isTerminated(slist, true, true, new HashSet<String>()) || this.hasFallThroughComment(ast))) {
            if (isLastGroup) {
                this.log(ast, MSG_FALL_THROUGH_LAST, new Object[0]);
            } else {
                this.log(nextGroup, MSG_FALL_THROUGH, new Object[0]);
            }
        }
    }

    private boolean isTerminated(DetailAST ast, boolean useBreak, boolean useContinue, Set<String> labelsForCurrentSwitchScope) {
        return switch (ast.getType()) {
            case 88, 90, 207 -> true;
            case 86 -> useBreak || FallThroughCheck.hasLabel(ast, labelsForCurrentSwitchScope);
            case 87 -> useContinue || FallThroughCheck.hasLabel(ast, labelsForCurrentSwitchScope);
            case 7 -> this.checkSlist(ast, useBreak, useContinue, labelsForCurrentSwitchScope);
            case 83 -> this.checkIf(ast, useBreak, useContinue, labelsForCurrentSwitchScope);
            case 84, 85, 91 -> this.checkLoop(ast, labelsForCurrentSwitchScope);
            case 95 -> this.checkTry(ast, useBreak, useContinue, labelsForCurrentSwitchScope);
            case 89 -> this.checkSwitch(ast, useContinue, labelsForCurrentSwitchScope);
            case 67 -> this.checkSynchronized(ast, useBreak, useContinue, labelsForCurrentSwitchScope);
            case 22 -> {
                labelsForCurrentSwitchScope.add(ast.getFirstChild().getText());
                yield this.isTerminated(ast.getLastChild(), useBreak, useContinue, labelsForCurrentSwitchScope);
            }
            default -> false;
        };
    }

    private static boolean hasLabel(DetailAST statement, Set<String> labelsForCurrentSwitchScope) {
        return Optional.ofNullable(statement).map(DetailAST::getFirstChild).filter(child -> child.getType() == 58).map(DetailAST::getText).filter(label -> !labelsForCurrentSwitchScope.contains(label)).isPresent();
    }

    private boolean checkSlist(DetailAST slistAst, boolean useBreak, boolean useContinue, Set<String> labels) {
        DetailAST lastStmt = slistAst.getLastChild();
        if (lastStmt.getType() == 73) {
            lastStmt = lastStmt.getPreviousSibling();
        }
        while (TokenUtil.isOfType(lastStmt, 144, 145)) {
            lastStmt = lastStmt.getPreviousSibling();
        }
        return lastStmt != null && this.isTerminated(lastStmt, useBreak, useContinue, labels);
    }

    private boolean checkIf(DetailAST ast, boolean useBreak, boolean useContinue, Set<String> labels) {
        DetailAST thenStmt = FallThroughCheck.getNextNonCommentAst(ast.findFirstToken(77));
        DetailAST elseStmt = FallThroughCheck.getNextNonCommentAst(thenStmt);
        return elseStmt != null && this.isTerminated(thenStmt, useBreak, useContinue, labels) && this.isTerminated(elseStmt.getLastChild(), useBreak, useContinue, labels);
    }

    private static DetailAST getNextNonCommentAst(DetailAST ast) {
        DetailAST nextSibling = ast.getNextSibling();
        while (TokenUtil.isOfType(nextSibling, 144, 145)) {
            nextSibling = nextSibling.getNextSibling();
        }
        return nextSibling;
    }

    private boolean checkLoop(DetailAST ast, Set<String> labels) {
        DetailAST loopBody;
        if (ast.getType() == 85) {
            DetailAST lparen = ast.findFirstToken(175);
            loopBody = lparen.getPreviousSibling();
        } else {
            DetailAST rparen = ast.findFirstToken(77);
            loopBody = rparen.getNextSibling();
        }
        return this.isTerminated(loopBody, false, false, labels);
    }

    private boolean checkTry(DetailAST ast, boolean useBreak, boolean useContinue, Set<String> labels) {
        boolean isTerminated;
        DetailAST finalStmt = ast.getLastChild();
        boolean bl = isTerminated = finalStmt.getType() == 97 && this.isTerminated(finalStmt.findFirstToken(7), useBreak, useContinue, labels);
        if (!isTerminated) {
            DetailAST firstChild = ast.getFirstChild();
            if (firstChild.getType() == 176) {
                firstChild = firstChild.getNextSibling();
            }
            isTerminated = this.isTerminated(firstChild, useBreak, useContinue, labels);
            for (DetailAST catchStmt = ast.findFirstToken(96); catchStmt != null && isTerminated && catchStmt.getType() == 96; catchStmt = catchStmt.getNextSibling()) {
                DetailAST catchBody = catchStmt.findFirstToken(7);
                isTerminated = this.isTerminated(catchBody, useBreak, useContinue, labels);
            }
        }
        return isTerminated;
    }

    private boolean checkSwitch(DetailAST literalSwitchAst, boolean useContinue, Set<String> labels) {
        boolean isTerminated;
        DetailAST caseGroup = literalSwitchAst.findFirstToken(33);
        boolean bl = isTerminated = caseGroup != null;
        while (isTerminated && caseGroup.getType() != 73) {
            DetailAST caseBody = caseGroup.findFirstToken(7);
            isTerminated = caseBody != null && this.isTerminated(caseBody, false, useContinue, labels);
            caseGroup = caseGroup.getNextSibling();
        }
        return isTerminated;
    }

    private boolean checkSynchronized(DetailAST synchronizedAst, boolean useBreak, boolean useContinue, Set<String> labels) {
        return this.isTerminated(synchronizedAst.findFirstToken(7), useBreak, useContinue, labels);
    }

    private boolean hasFallThroughComment(DetailAST currentCase) {
        DetailAST nextSibling = currentCase.getNextSibling();
        DetailAST ast = nextSibling.getType() == 33 ? nextSibling.getFirstChild() : currentCase;
        return this.hasReliefComment(ast);
    }

    private boolean hasReliefComment(DetailAST ast) {
        DetailAST nonCommentAst = FallThroughCheck.getNextNonCommentAst(ast);
        boolean result = false;
        if (nonCommentAst != null) {
            int prevLineNumber = nonCommentAst.getPreviousSibling().getLineNo();
            result = Stream.iterate(nonCommentAst.getPreviousSibling(), Objects::nonNull, DetailAST::getPreviousSibling).takeWhile(sibling -> sibling.getLineNo() == prevLineNumber).map(DetailAST::getFirstChild).filter(Objects::nonNull).anyMatch(firstChild -> this.reliefPattern.matcher(firstChild.getText()).find());
        }
        return result;
    }
}

