/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.utils;

import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Arrays;

public final class CodePointUtil {
    private CodePointUtil() {
    }

    public static boolean isBlank(int ... codePoints) {
        return CodePointUtil.hasWhitespaceBefore(codePoints.length, codePoints);
    }

    public static boolean hasWhitespaceBefore(int index, int ... codePoints) {
        return Arrays.stream(codePoints, 0, index).allMatch(Character::isWhitespace);
    }

    public static int[] stripTrailing(int ... codePoints) {
        int lastIndex;
        for (lastIndex = codePoints.length; lastIndex > 0 && CommonUtil.isCodePointWhitespace(codePoints, lastIndex - 1); --lastIndex) {
        }
        return Arrays.copyOfRange(codePoints, 0, lastIndex);
    }

    public static int[] stripLeading(int ... codePoints) {
        int startIndex;
        for (startIndex = 0; startIndex < codePoints.length && CommonUtil.isCodePointWhitespace(codePoints, startIndex); ++startIndex) {
        }
        return Arrays.copyOfRange(codePoints, startIndex, codePoints.length);
    }

    public static int[] trim(int ... codePoints) {
        int[] strippedCodePoints = CodePointUtil.stripTrailing(codePoints);
        return CodePointUtil.stripLeading(strippedCodePoints);
    }

    public static boolean endsWith(int[] codePoints, String suffix) {
        int startIndex = codePoints.length - suffix.length();
        return startIndex > -1 && Arrays.equals(Arrays.copyOfRange(codePoints, startIndex, codePoints.length), suffix.codePoints().toArray());
    }
}

