/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CodePointUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import java.util.Arrays;

@StatelessCheck
public class SingleSpaceSeparatorCheck
extends AbstractCheck {
    public static final String MSG_KEY = "single.space.separator";
    private boolean validateComments;

    public void setValidateComments(boolean validateComments) {
        this.validateComments = validateComments;
    }

    @Override
    public int[] getDefaultTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return this.getRequiredTokens();
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public boolean isCommentNodesRequired() {
        return this.validateComments;
    }

    @Override
    public void beginTree(DetailAST rootAST) {
        if (rootAST != null) {
            this.visitEachToken(rootAST);
        }
    }

    private void visitEachToken(DetailAST node) {
        DetailAST currentNode = node;
        DetailAST parent = node.getParent();
        do {
            int columnNo = currentNode.getColumnNo() - 1;
            int minSecondWhitespaceColumnNo = 2;
            if (columnNo >= 2 && !this.isTextSeparatedCorrectlyFromPrevious(this.getLineCodePoints(currentNode.getLineNo() - 1), columnNo)) {
                this.log(currentNode, MSG_KEY, new Object[0]);
            }
            if (currentNode.hasChildren()) {
                currentNode = currentNode.getFirstChild();
                continue;
            }
            while (currentNode.getNextSibling() == null && currentNode.getParent() != parent) {
                currentNode = currentNode.getParent();
            }
            currentNode = currentNode.getNextSibling();
        } while (currentNode != null);
    }

    private boolean isTextSeparatedCorrectlyFromPrevious(int[] line, int columnNo) {
        return SingleSpaceSeparatorCheck.isSingleSpace(line, columnNo) || !CommonUtil.isCodePointWhitespace(line, columnNo) || SingleSpaceSeparatorCheck.isFirstInLine(line, columnNo) || !this.validateComments && SingleSpaceSeparatorCheck.isBlockCommentEnd(line, columnNo);
    }

    private static boolean isSingleSpace(int[] line, int columnNo) {
        return SingleSpaceSeparatorCheck.isSpace(line, columnNo) && !CommonUtil.isCodePointWhitespace(line, columnNo - 1);
    }

    private static boolean isSpace(int[] line, int columnNo) {
        return line[columnNo] == 32;
    }

    private static boolean isFirstInLine(int[] line, int columnNo) {
        return CodePointUtil.isBlank(Arrays.copyOfRange(line, 0, columnNo));
    }

    private static boolean isBlockCommentEnd(int[] line, int columnNo) {
        int[] strippedLine = CodePointUtil.stripTrailing(Arrays.copyOfRange(line, 0, columnNo));
        return CodePointUtil.endsWith(strippedLine, "*/");
    }
}

