/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.site;

import com.puppycrawl.tools.checkstyle.Checker;
import com.puppycrawl.tools.checkstyle.PackageNamesLoader;
import com.puppycrawl.tools.checkstyle.PackageObjectFactory;
import com.puppycrawl.tools.checkstyle.TreeWalker;
import com.puppycrawl.tools.checkstyle.TreeWalkerFilter;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractFileSetCheck;
import com.puppycrawl.tools.checkstyle.api.BeforeExecutionFileFilter;
import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.Filter;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpMultilineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineCheck;
import com.puppycrawl.tools.checkstyle.checks.regexp.RegexpSinglelineJavaCheck;
import com.puppycrawl.tools.checkstyle.site.ViolationMessagesMacro;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.doxia.macro.MacroExecutionException;

public final class SiteUtil {
    private static final Map<Class<?>, String> CLASS_TO_PARENT_MODULE = Map.ofEntries(Map.entry(AbstractCheck.class, TreeWalker.class.getSimpleName()), Map.entry(TreeWalkerFilter.class, TreeWalker.class.getSimpleName()), Map.entry(AbstractFileSetCheck.class, Checker.class.getSimpleName()), Map.entry(Filter.class, Checker.class.getSimpleName()), Map.entry(BeforeExecutionFileFilter.class, Checker.class.getSimpleName()));

    private SiteUtil() {
    }

    public static Set<String> getMessageKeys(Class<?> module) throws MacroExecutionException {
        Set<Field> messageKeyFields = SiteUtil.getCheckMessageKeys(module);
        TreeSet<String> messageKeys = new TreeSet<String>();
        for (Field field : messageKeyFields) {
            messageKeys.add(SiteUtil.getFieldValue(field, module));
        }
        return messageKeys;
    }

    private static Set<Field> getCheckMessageKeys(Class<?> module) throws MacroExecutionException {
        try {
            Field[] fields;
            HashSet<Field> checkstyleMessages = new HashSet<Field>();
            for (Field field : fields = module.getDeclaredFields()) {
                if (!field.getName().startsWith("MSG_")) continue;
                checkstyleMessages.add(field);
            }
            Class<?> superModule = module.getSuperclass();
            if (superModule != null) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(superModule));
            }
            if (module == RegexpMultilineCheck.class) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.MultilineDetector")));
            } else if (module == RegexpSinglelineCheck.class || module == RegexpSinglelineJavaCheck.class) {
                checkstyleMessages.addAll(SiteUtil.getCheckMessageKeys(Class.forName("com.puppycrawl.tools.checkstyle.checks.regexp.SinglelineDetector")));
            }
            return checkstyleMessages;
        }
        catch (ClassNotFoundException ex) {
            String message = String.format(Locale.ROOT, "Couldn't find class: %s", module.getName());
            throw new MacroExecutionException(message, (Throwable)ex);
        }
    }

    private static String getFieldValue(Field field, Object instance) throws MacroExecutionException {
        try {
            field.trySetAccessible();
            return field.get(instance).toString();
        }
        catch (IllegalAccessException ex) {
            throw new MacroExecutionException("Couldn't get field value", (Throwable)ex);
        }
    }

    public static Object getModuleInstance(String moduleName) throws MacroExecutionException {
        PackageObjectFactory factory = SiteUtil.getPackageObjectFactory();
        try {
            return factory.createModule(moduleName);
        }
        catch (CheckstyleException ex) {
            throw new MacroExecutionException("Couldn't find class: " + moduleName, (Throwable)ex);
        }
    }

    private static PackageObjectFactory getPackageObjectFactory() throws MacroExecutionException {
        try {
            ClassLoader cl = ViolationMessagesMacro.class.getClassLoader();
            Set<String> packageNames = PackageNamesLoader.getPackageNames(cl);
            return new PackageObjectFactory(packageNames, cl);
        }
        catch (CheckstyleException ex) {
            throw new MacroExecutionException("Couldn't load checkstyle modules", (Throwable)ex);
        }
    }

    public static String getNewlineAndIndentSpaces(int amountOfSpaces) {
        return System.lineSeparator() + " ".repeat(amountOfSpaces);
    }

    public static Set<Path> getXdocsTemplatesFilePaths() throws MacroExecutionException {
        Set<Path> set;
        block8: {
            Path directory = Paths.get("src/xdocs", new String[0]);
            Stream<Path> stream = Files.find(directory, Integer.MAX_VALUE, (path, attr) -> attr.isRegularFile() && path.toString().endsWith(".xml.template"), new FileVisitOption[0]);
            try {
                set = stream.collect(Collectors.toSet());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ioException) {
                    throw new MacroExecutionException("Failed to find xdocs templates", (Throwable)ioException);
                }
            }
            stream.close();
        }
        return set;
    }

    public static String getParentModule(Class<?> moduleClass) throws MacroExecutionException {
        String parentModuleName = "";
        for (Class<?> parentClass = moduleClass.getSuperclass(); parentClass != null && (parentModuleName = CLASS_TO_PARENT_MODULE.get(parentClass)) == null; parentClass = parentClass.getSuperclass()) {
        }
        if (parentModuleName == null || parentModuleName.isEmpty()) {
            Class<?> interfaceClass;
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = moduleClass.getInterfaces();
            int n = classArray.length;
            for (int i = 0; i < n && (parentModuleName = CLASS_TO_PARENT_MODULE.get(interfaceClass = classArray[i])) == null; ++i) {
            }
        }
        if (parentModuleName == null || parentModuleName.isEmpty()) {
            String message = String.format(Locale.ROOT, "Failed to find parent module for %s", moduleClass.getSimpleName());
            throw new MacroExecutionException(message);
        }
        return parentModuleName;
    }
}

