/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.spotinst.spark.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class OceanWebhook {
    @Nullable
    private List<Integer> hostNetworkPorts;
    @Nullable
    private Boolean useHostNetwork;

    private OceanWebhook() {
    }

    public List<Integer> hostNetworkPorts() {
        return this.hostNetworkPorts == null ? List.of() : this.hostNetworkPorts;
    }

    public Optional<Boolean> useHostNetwork() {
        return Optional.ofNullable(this.useHostNetwork);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OceanWebhook defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<Integer> hostNetworkPorts;
        @Nullable
        private Boolean useHostNetwork;

        public Builder() {
        }

        public Builder(OceanWebhook defaults) {
            Objects.requireNonNull(defaults);
            this.hostNetworkPorts = defaults.hostNetworkPorts;
            this.useHostNetwork = defaults.useHostNetwork;
        }

        @CustomType.Setter
        public Builder hostNetworkPorts(@Nullable List<Integer> hostNetworkPorts) {
            this.hostNetworkPorts = hostNetworkPorts;
            return this;
        }

        public Builder hostNetworkPorts(Integer ... hostNetworkPorts) {
            return this.hostNetworkPorts(List.of(hostNetworkPorts));
        }

        @CustomType.Setter
        public Builder useHostNetwork(@Nullable Boolean useHostNetwork) {
            this.useHostNetwork = useHostNetwork;
            return this;
        }

        public OceanWebhook build() {
            OceanWebhook o = new OceanWebhook();
            o.hostNetworkPorts = this.hostNetworkPorts;
            o.useHostNetwork = this.useHostNetwork;
            return o;
        }
    }
}

