/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.spotinst.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StatefulNodeAzureLoadBalancer {
    private List<String> backendPoolNames;
    private String name;
    private String resourceGroupName;
    @Nullable
    private String sku;
    private String type;

    private StatefulNodeAzureLoadBalancer() {
    }

    public List<String> backendPoolNames() {
        return this.backendPoolNames;
    }

    public String name() {
        return this.name;
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public Optional<String> sku() {
        return Optional.ofNullable(this.sku);
    }

    public String type() {
        return this.type;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StatefulNodeAzureLoadBalancer defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> backendPoolNames;
        private String name;
        private String resourceGroupName;
        @Nullable
        private String sku;
        private String type;

        public Builder() {
        }

        public Builder(StatefulNodeAzureLoadBalancer defaults) {
            Objects.requireNonNull(defaults);
            this.backendPoolNames = defaults.backendPoolNames;
            this.name = defaults.name;
            this.resourceGroupName = defaults.resourceGroupName;
            this.sku = defaults.sku;
            this.type = defaults.type;
        }

        @CustomType.Setter
        public Builder backendPoolNames(List<String> backendPoolNames) {
            this.backendPoolNames = Objects.requireNonNull(backendPoolNames);
            return this;
        }

        public Builder backendPoolNames(String ... backendPoolNames) {
            return this.backendPoolNames(List.of(backendPoolNames));
        }

        @CustomType.Setter
        public Builder name(String name) {
            this.name = Objects.requireNonNull(name);
            return this;
        }

        @CustomType.Setter
        public Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = Objects.requireNonNull(resourceGroupName);
            return this;
        }

        @CustomType.Setter
        public Builder sku(@Nullable String sku) {
            this.sku = sku;
            return this;
        }

        @CustomType.Setter
        public Builder type(String type) {
            this.type = Objects.requireNonNull(type);
            return this;
        }

        public StatefulNodeAzureLoadBalancer build() {
            StatefulNodeAzureLoadBalancer o = new StatefulNodeAzureLoadBalancer();
            o.backendPoolNames = this.backendPoolNames;
            o.name = this.name;
            o.resourceGroupName = this.resourceGroupName;
            o.sku = this.sku;
            o.type = this.type;
            return o;
        }
    }
}

