/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.spotinst.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class StatefulNodeAzureHealth {
    private Boolean autoHealing;
    @Nullable
    private Integer gracePeriod;
    private List<String> healthCheckTypes;
    @Nullable
    private Integer unhealthyDuration;

    private StatefulNodeAzureHealth() {
    }

    public Boolean autoHealing() {
        return this.autoHealing;
    }

    public Optional<Integer> gracePeriod() {
        return Optional.ofNullable(this.gracePeriod);
    }

    public List<String> healthCheckTypes() {
        return this.healthCheckTypes;
    }

    public Optional<Integer> unhealthyDuration() {
        return Optional.ofNullable(this.unhealthyDuration);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(StatefulNodeAzureHealth defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private Boolean autoHealing;
        @Nullable
        private Integer gracePeriod;
        private List<String> healthCheckTypes;
        @Nullable
        private Integer unhealthyDuration;

        public Builder() {
        }

        public Builder(StatefulNodeAzureHealth defaults) {
            Objects.requireNonNull(defaults);
            this.autoHealing = defaults.autoHealing;
            this.gracePeriod = defaults.gracePeriod;
            this.healthCheckTypes = defaults.healthCheckTypes;
            this.unhealthyDuration = defaults.unhealthyDuration;
        }

        @CustomType.Setter
        public Builder autoHealing(Boolean autoHealing) {
            this.autoHealing = Objects.requireNonNull(autoHealing);
            return this;
        }

        @CustomType.Setter
        public Builder gracePeriod(@Nullable Integer gracePeriod) {
            this.gracePeriod = gracePeriod;
            return this;
        }

        @CustomType.Setter
        public Builder healthCheckTypes(List<String> healthCheckTypes) {
            this.healthCheckTypes = Objects.requireNonNull(healthCheckTypes);
            return this;
        }

        public Builder healthCheckTypes(String ... healthCheckTypes) {
            return this.healthCheckTypes(List.of(healthCheckTypes));
        }

        @CustomType.Setter
        public Builder unhealthyDuration(@Nullable Integer unhealthyDuration) {
            this.unhealthyDuration = unhealthyDuration;
            return this;
        }

        public StatefulNodeAzureHealth build() {
            StatefulNodeAzureHealth o = new StatefulNodeAzureHealth();
            o.autoHealing = this.autoHealing;
            o.gracePeriod = this.gracePeriod;
            o.healthCheckTypes = this.healthCheckTypes;
            o.unhealthyDuration = this.unhealthyDuration;
            return o;
        }
    }
}

