/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.spotinst.multai.outputs;

import com.pulumi.core.annotations.CustomType;
import java.util.List;
import java.util.Objects;

@CustomType
public final class ListenerTlsConfig {
    private List<String> certificateIds;
    private List<String> cipherSuites;
    private String maxVersion;
    private String minVersion;
    private Boolean preferServerCipherSuites;
    private Boolean sessionTicketsDisabled;

    private ListenerTlsConfig() {
    }

    public List<String> certificateIds() {
        return this.certificateIds;
    }

    public List<String> cipherSuites() {
        return this.cipherSuites;
    }

    public String maxVersion() {
        return this.maxVersion;
    }

    public String minVersion() {
        return this.minVersion;
    }

    public Boolean preferServerCipherSuites() {
        return this.preferServerCipherSuites;
    }

    public Boolean sessionTicketsDisabled() {
        return this.sessionTicketsDisabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ListenerTlsConfig defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        private List<String> certificateIds;
        private List<String> cipherSuites;
        private String maxVersion;
        private String minVersion;
        private Boolean preferServerCipherSuites;
        private Boolean sessionTicketsDisabled;

        public Builder() {
        }

        public Builder(ListenerTlsConfig defaults) {
            Objects.requireNonNull(defaults);
            this.certificateIds = defaults.certificateIds;
            this.cipherSuites = defaults.cipherSuites;
            this.maxVersion = defaults.maxVersion;
            this.minVersion = defaults.minVersion;
            this.preferServerCipherSuites = defaults.preferServerCipherSuites;
            this.sessionTicketsDisabled = defaults.sessionTicketsDisabled;
        }

        @CustomType.Setter
        public Builder certificateIds(List<String> certificateIds) {
            this.certificateIds = Objects.requireNonNull(certificateIds);
            return this;
        }

        public Builder certificateIds(String ... certificateIds) {
            return this.certificateIds(List.of(certificateIds));
        }

        @CustomType.Setter
        public Builder cipherSuites(List<String> cipherSuites) {
            this.cipherSuites = Objects.requireNonNull(cipherSuites);
            return this;
        }

        public Builder cipherSuites(String ... cipherSuites) {
            return this.cipherSuites(List.of(cipherSuites));
        }

        @CustomType.Setter
        public Builder maxVersion(String maxVersion) {
            this.maxVersion = Objects.requireNonNull(maxVersion);
            return this;
        }

        @CustomType.Setter
        public Builder minVersion(String minVersion) {
            this.minVersion = Objects.requireNonNull(minVersion);
            return this;
        }

        @CustomType.Setter
        public Builder preferServerCipherSuites(Boolean preferServerCipherSuites) {
            this.preferServerCipherSuites = Objects.requireNonNull(preferServerCipherSuites);
            return this;
        }

        @CustomType.Setter
        public Builder sessionTicketsDisabled(Boolean sessionTicketsDisabled) {
            this.sessionTicketsDisabled = Objects.requireNonNull(sessionTicketsDisabled);
            return this;
        }

        public ListenerTlsConfig build() {
            ListenerTlsConfig o = new ListenerTlsConfig();
            o.certificateIds = this.certificateIds;
            o.cipherSuites = this.cipherSuites;
            o.maxVersion = this.maxVersion;
            o.minVersion = this.minVersion;
            o.preferServerCipherSuites = this.preferServerCipherSuites;
            o.sessionTicketsDisabled = this.sessionTicketsDisabled;
            return o;
        }
    }
}

