/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.spotinst.azure.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.spotinst.azure.outputs.OceanNetworkNetworkInterface;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class OceanNetwork {
    @Nullable
    private List<OceanNetworkNetworkInterface> networkInterfaces;
    @Nullable
    private String resourceGroupName;
    @Nullable
    private String virtualNetworkName;

    private OceanNetwork() {
    }

    public List<OceanNetworkNetworkInterface> networkInterfaces() {
        return this.networkInterfaces == null ? List.of() : this.networkInterfaces;
    }

    public Optional<String> resourceGroupName() {
        return Optional.ofNullable(this.resourceGroupName);
    }

    public Optional<String> virtualNetworkName() {
        return Optional.ofNullable(this.virtualNetworkName);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OceanNetwork defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<OceanNetworkNetworkInterface> networkInterfaces;
        @Nullable
        private String resourceGroupName;
        @Nullable
        private String virtualNetworkName;

        public Builder() {
        }

        public Builder(OceanNetwork defaults) {
            Objects.requireNonNull(defaults);
            this.networkInterfaces = defaults.networkInterfaces;
            this.resourceGroupName = defaults.resourceGroupName;
            this.virtualNetworkName = defaults.virtualNetworkName;
        }

        @CustomType.Setter
        public Builder networkInterfaces(@Nullable List<OceanNetworkNetworkInterface> networkInterfaces) {
            this.networkInterfaces = networkInterfaces;
            return this;
        }

        public Builder networkInterfaces(OceanNetworkNetworkInterface ... networkInterfaces) {
            return this.networkInterfaces(List.of(networkInterfaces));
        }

        @CustomType.Setter
        public Builder resourceGroupName(@Nullable String resourceGroupName) {
            this.resourceGroupName = resourceGroupName;
            return this;
        }

        @CustomType.Setter
        public Builder virtualNetworkName(@Nullable String virtualNetworkName) {
            this.virtualNetworkName = virtualNetworkName;
            return this;
        }

        public OceanNetwork build() {
            OceanNetwork o = new OceanNetwork();
            o.networkInterfaces = this.networkInterfaces;
            o.resourceGroupName = this.resourceGroupName;
            o.virtualNetworkName = this.virtualNetworkName;
            return o;
        }
    }
}

