/*
 * Decompiled with CFR 0.152.
 */
package com.pulumi.spotinst.azure.outputs;

import com.pulumi.core.annotations.CustomType;
import com.pulumi.spotinst.azure.outputs.ElastigroupNetworkAdditionalIpConfig;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@CustomType
public final class ElastigroupNetwork {
    @Nullable
    private List<ElastigroupNetworkAdditionalIpConfig> additionalIpConfigs;
    @Nullable
    private Boolean assignPublicIp;
    private String resourceGroupName;
    private String subnetName;
    private String virtualNetworkName;

    private ElastigroupNetwork() {
    }

    public List<ElastigroupNetworkAdditionalIpConfig> additionalIpConfigs() {
        return this.additionalIpConfigs == null ? List.of() : this.additionalIpConfigs;
    }

    public Optional<Boolean> assignPublicIp() {
        return Optional.ofNullable(this.assignPublicIp);
    }

    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    public String subnetName() {
        return this.subnetName;
    }

    public String virtualNetworkName() {
        return this.virtualNetworkName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ElastigroupNetwork defaults) {
        return new Builder(defaults);
    }

    @CustomType.Builder
    public static final class Builder {
        @Nullable
        private List<ElastigroupNetworkAdditionalIpConfig> additionalIpConfigs;
        @Nullable
        private Boolean assignPublicIp;
        private String resourceGroupName;
        private String subnetName;
        private String virtualNetworkName;

        public Builder() {
        }

        public Builder(ElastigroupNetwork defaults) {
            Objects.requireNonNull(defaults);
            this.additionalIpConfigs = defaults.additionalIpConfigs;
            this.assignPublicIp = defaults.assignPublicIp;
            this.resourceGroupName = defaults.resourceGroupName;
            this.subnetName = defaults.subnetName;
            this.virtualNetworkName = defaults.virtualNetworkName;
        }

        @CustomType.Setter
        public Builder additionalIpConfigs(@Nullable List<ElastigroupNetworkAdditionalIpConfig> additionalIpConfigs) {
            this.additionalIpConfigs = additionalIpConfigs;
            return this;
        }

        public Builder additionalIpConfigs(ElastigroupNetworkAdditionalIpConfig ... additionalIpConfigs) {
            return this.additionalIpConfigs(List.of(additionalIpConfigs));
        }

        @CustomType.Setter
        public Builder assignPublicIp(@Nullable Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @CustomType.Setter
        public Builder resourceGroupName(String resourceGroupName) {
            this.resourceGroupName = Objects.requireNonNull(resourceGroupName);
            return this;
        }

        @CustomType.Setter
        public Builder subnetName(String subnetName) {
            this.subnetName = Objects.requireNonNull(subnetName);
            return this;
        }

        @CustomType.Setter
        public Builder virtualNetworkName(String virtualNetworkName) {
            this.virtualNetworkName = Objects.requireNonNull(virtualNetworkName);
            return this;
        }

        public ElastigroupNetwork build() {
            ElastigroupNetwork o = new ElastigroupNetwork();
            o.additionalIpConfigs = this.additionalIpConfigs;
            o.assignPublicIp = this.assignPublicIp;
            o.resourceGroupName = this.resourceGroupName;
            o.subnetName = this.subnetName;
            o.virtualNetworkName = this.virtualNetworkName;
            return o;
        }
    }
}

