/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.utils;

import com.publit.publit_io.exception.PublitioExceptions;
import com.publit.publit_io.utils.APIConfiguration;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Random;

public class SHAGenerator {
    private String apiTimeStamp;
    private String apiNonce;
    private String apiSignature;
    private boolean isValidated = false;

    public SHAGenerator() {
        try {
            this.isValidated = this.validateAPI(APIConfiguration.apiKey, APIConfiguration.apiSecret);
        }
        catch (PublitioExceptions publitioExceptions) {
            publitioExceptions.printStackTrace();
        }
        this.generateSHA();
    }

    private void generateSHA() {
        this.apiTimeStamp = String.valueOf(new Date().getTime() / 1000L);
        Random rnd = new Random();
        this.apiNonce = String.valueOf(10000000L + (long)rnd.nextInt(900000) * 100L + (long)rnd.nextInt(100));
        if (this.isValidated) {
            String concatinatedString = this.apiTimeStamp.concat(this.apiNonce).concat(APIConfiguration.apiSecret);
            this.apiSignature = this.hashString(concatinatedString, "SHA-1");
        }
    }

    private String hashString(String concatinatedString, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = digest.digest(concatinatedString.getBytes("UTF-8"));
            return this.convertByteArrayToHexString(hashedBytes);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            return "";
        }
    }

    private String convertByteArrayToHexString(byte[] hashedBytes) {
        StringBuilder stringBuffer = new StringBuilder();
        for (byte hashedByte : hashedBytes) {
            stringBuffer.append(Integer.toString((hashedByte & 0xFF) + 256, 16).substring(1));
        }
        return stringBuffer.toString();
    }

    private boolean validateAPI(String apiKey, String apiSecret) throws PublitioExceptions {
        if (apiSecret == null || apiSecret.isEmpty() || apiKey == null || apiKey.isEmpty()) {
            throw new PublitioExceptions("Publitio API key or API secret is not set.");
        }
        return true;
    }

    public String getApiTimeStamp() {
        return this.apiTimeStamp;
    }

    public String getApiNonce() {
        return this.apiNonce;
    }

    public String getApiSignature() {
        return this.apiSignature;
    }
}

