/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.videocompressor;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.os.Build;
import android.util.Log;
import com.publit.publit_io.videocompressor.InputSurface;
import com.publit.publit_io.videocompressor.MP4Builder;
import com.publit.publit_io.videocompressor.Mp4Movie;
import com.publit.publit_io.videocompressor.OutputSurface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

@SuppressLint(value={"NewApi"})
public class VideoController {
    static final int COMPRESS_QUALITY_HIGH = 1;
    static final int COMPRESS_QUALITY_MEDIUM = 2;
    static final int COMPRESS_QUALITY_LOW = 3;
    public static File cachedFile;
    public String path;
    public static final String MIME_TYPE = "video/avc";
    private static final int PROCESSOR_TYPE_OTHER = 0;
    private static final int PROCESSOR_TYPE_QCOM = 1;
    private static final int PROCESSOR_TYPE_INTEL = 2;
    private static final int PROCESSOR_TYPE_MTK = 3;
    private static final int PROCESSOR_TYPE_SEC = 4;
    private static final int PROCESSOR_TYPE_TI = 5;
    private static volatile VideoController Instance;
    private boolean videoConvertFirstWrite = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VideoController getInstance() {
        VideoController localInstance = Instance;
        if (localInstance != null) return localInstance;
        Class<VideoController> clazz = VideoController.class;
        synchronized (VideoController.class) {
            localInstance = Instance;
            if (localInstance != null) return localInstance;
            Instance = localInstance = new VideoController();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return localInstance;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int selectColorFormat(MediaCodecInfo codecInfo, String mimeType) {
        MediaCodecInfo.CodecCapabilities capabilities = codecInfo.getCapabilitiesForType(mimeType);
        int lastColorFormat = 0;
        for (int i = 0; i < capabilities.colorFormats.length; ++i) {
            int colorFormat = capabilities.colorFormats[i];
            if (!VideoController.isRecognizedFormat(colorFormat)) continue;
            lastColorFormat = colorFormat;
            if (codecInfo.getName().equals("OMX.SEC.AVC.Encoder") && colorFormat == 19) continue;
            return colorFormat;
        }
        return lastColorFormat;
    }

    private static boolean isRecognizedFormat(int colorFormat) {
        switch (colorFormat) {
            case 19: 
            case 20: 
            case 21: 
            case 39: 
            case 2130706688: {
                return true;
            }
        }
        return false;
    }

    public static native int convertVideoFrame(ByteBuffer var0, ByteBuffer var1, int var2, int var3, int var4, int var5, int var6);

    private void didWriteData(boolean last, boolean error) {
        boolean firstWrite = this.videoConvertFirstWrite;
        if (firstWrite) {
            this.videoConvertFirstWrite = false;
        }
    }

    public static MediaCodecInfo selectCodec(String mimeType) {
        int numCodecs = MediaCodecList.getCodecCount();
        MediaCodecInfo lastCodecInfo = null;
        for (int i = 0; i < numCodecs; ++i) {
            String[] types;
            MediaCodecInfo codecInfo = MediaCodecList.getCodecInfoAt((int)i);
            if (!codecInfo.isEncoder()) continue;
            for (String type : types = codecInfo.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                lastCodecInfo = codecInfo;
                if (!lastCodecInfo.getName().equals("OMX.SEC.avc.enc")) {
                    return lastCodecInfo;
                }
                if (!lastCodecInfo.getName().equals("OMX.SEC.AVC.Encoder")) continue;
                return lastCodecInfo;
            }
        }
        return lastCodecInfo;
    }

    public void scheduleVideoConvert(String path, String dest) {
        this.startVideoConvertFromQueue(path, dest);
    }

    private void startVideoConvertFromQueue(String path, String dest) {
        VideoConvertRunnable.runConversion(path, dest);
    }

    @TargetApi(value=16)
    private long readAndWriteTrack(MediaExtractor extractor, MP4Builder mediaMuxer, MediaCodec.BufferInfo info, long start, long end, File file, boolean isAudio) throws Exception {
        int trackIndex = this.selectTrack(extractor, isAudio);
        if (trackIndex >= 0) {
            extractor.selectTrack(trackIndex);
            MediaFormat trackFormat = extractor.getTrackFormat(trackIndex);
            int muxerTrackIndex = mediaMuxer.addTrack(trackFormat, isAudio);
            int maxBufferSize = trackFormat.getInteger("max-input-size");
            boolean inputDone = false;
            if (start > 0L) {
                extractor.seekTo(start, 0);
            } else {
                extractor.seekTo(0L, 0);
            }
            ByteBuffer buffer = ByteBuffer.allocateDirect(maxBufferSize);
            long startTime = -1L;
            while (!inputDone) {
                boolean eof = false;
                int index = extractor.getSampleTrackIndex();
                if (index == trackIndex) {
                    info.size = extractor.readSampleData(buffer, 0);
                    if (info.size < 0) {
                        info.size = 0;
                        eof = true;
                    } else {
                        info.presentationTimeUs = extractor.getSampleTime();
                        if (start > 0L && startTime == -1L) {
                            startTime = info.presentationTimeUs;
                        }
                        if (end < 0L || info.presentationTimeUs < end) {
                            info.offset = 0;
                            info.flags = extractor.getSampleFlags();
                            if (mediaMuxer.writeSampleData(muxerTrackIndex, buffer, info, isAudio)) {
                                // empty if block
                            }
                            extractor.advance();
                        } else {
                            eof = true;
                        }
                    }
                } else if (index == -1) {
                    eof = true;
                }
                if (!eof) continue;
                inputDone = true;
            }
            extractor.unselectTrack(trackIndex);
            return startTime;
        }
        return -1L;
    }

    @TargetApi(value=16)
    private int selectTrack(MediaExtractor extractor, boolean audio) {
        int numTracks = extractor.getTrackCount();
        for (int i = 0; i < numTracks; ++i) {
            MediaFormat format = extractor.getTrackFormat(i);
            String mime = format.getString("mime");
            if (!(audio ? mime.startsWith("audio/") : mime.startsWith("video/"))) continue;
            return i;
        }
        return -5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @TargetApi(value=16)
    public boolean convertVideo(String sourcePath, String destinationPath, int quality, CompressProgressListener listener) {
        this.path = sourcePath;
        retriever = new MediaMetadataRetriever();
        try {
            input = new FileInputStream(this.path);
            retriever.setDataSource(input.getFD());
        }
        catch (Exception e) {
            Log.e((String)"Error", (String)e.toString());
        }
        width = retriever.extractMetadata(18);
        height = retriever.extractMetadata(19);
        rotation = retriever.extractMetadata(24);
        duration = Long.valueOf(retriever.extractMetadata(9)) * 1000L;
        startTime = -1L;
        endTime = -1L;
        rotationValue = Integer.valueOf(rotation);
        originalWidth = Integer.valueOf(width);
        originalHeight = Integer.valueOf(height);
        switch (quality) {
            default: {
                resultWidth = originalWidth * 2 / 3;
                resultHeight = originalHeight * 2 / 3;
                bitrate = resultWidth * resultHeight * 30;
                break;
            }
            case 2: {
                resultWidth = originalWidth / 2;
                resultHeight = originalHeight / 2;
                bitrate = resultWidth * resultHeight * 10;
                break;
            }
            case 3: {
                resultWidth = originalWidth / 2;
                resultHeight = originalHeight / 2;
                bitrate = resultWidth / 2 * (resultHeight / 2) * 10;
            }
        }
        rotateRender = 0;
        cacheFile = new File(destinationPath);
        if (Build.VERSION.SDK_INT < 18 && resultHeight > resultWidth && resultWidth != originalWidth && resultHeight != originalHeight) {
            temp = resultHeight;
            resultHeight = resultWidth;
            resultWidth = temp;
            rotationValue = 90;
            rotateRender = 270;
        } else if (Build.VERSION.SDK_INT > 20) {
            if (rotationValue == 90) {
                temp = resultHeight;
                resultHeight = resultWidth;
                resultWidth = temp;
                rotationValue = 0;
                rotateRender = 270;
            } else if (rotationValue == 180) {
                rotateRender = 180;
                rotationValue = 0;
            } else if (rotationValue == 270) {
                temp = resultHeight;
                resultHeight = resultWidth;
                resultWidth = temp;
                rotationValue = 0;
                rotateRender = 90;
            }
        }
        inputFile = new File(this.path);
        if (!inputFile.canRead()) {
            this.didWriteData(true, true);
            return false;
        }
        this.videoConvertFirstWrite = true;
        error = false;
        videoStartTime = startTime;
        time = System.currentTimeMillis();
        if (resultWidth != 0 && resultHeight != 0) {
            mediaMuxer = null;
            extractor = null;
            try {
                info = new MediaCodec.BufferInfo();
                movie = new Mp4Movie();
                movie.setCacheFile(cacheFile);
                movie.setRotation(rotationValue);
                movie.setSize(resultWidth, resultHeight);
                mediaMuxer = new MP4Builder().createMovie(movie);
                extractor = new MediaExtractor();
                extractor.setDataSource(inputFile.toString());
                if (resultWidth != originalWidth || resultHeight != originalHeight) {
                    videoIndex = this.selectTrack(extractor, false);
                    if (videoIndex >= 0) {
                        decoder = null;
                        encoder = null;
                        inputSurface = null;
                        outputSurface = null;
                        try {
                            videoTime = -1L;
                            outputDone = false;
                            inputDone = false;
                            decoderDone = false;
                            swapUV = 0;
                            videoTrackIndex = -5;
                            processorType = 0;
                            manufacturer = Build.MANUFACTURER.toLowerCase();
                            if (Build.VERSION.SDK_INT < 18) {
                                codecInfo = VideoController.selectCodec("video/avc");
                                colorFormat = VideoController.selectColorFormat(codecInfo, "video/avc");
                                if (colorFormat == 0) {
                                    throw new RuntimeException("no supported color format");
                                }
                                codecName = codecInfo.getName();
                                if (codecName.contains("OMX.qcom.")) {
                                    processorType = 1;
                                    if (Build.VERSION.SDK_INT == 16 && (manufacturer.equals("lge") || manufacturer.equals("nokia"))) {
                                        swapUV = 1;
                                    }
                                } else if (codecName.contains("OMX.Intel.")) {
                                    processorType = 2;
                                } else if (codecName.equals("OMX.MTK.VIDEO.ENCODER.AVC")) {
                                    processorType = 3;
                                } else if (codecName.equals("OMX.SEC.AVC.Encoder")) {
                                    processorType = 4;
                                    swapUV = 1;
                                } else if (codecName.equals("OMX.TI.DUCATI1.VIDEO.H264E")) {
                                    processorType = 5;
                                }
                                Log.e((String)"tmessages", (String)("codec = " + codecInfo.getName() + " manufacturer = " + manufacturer + "device = " + Build.MODEL));
                            } else {
                                colorFormat = 2130708361;
                            }
                            Log.e((String)"tmessages", (String)("colorFormat = " + colorFormat));
                            resultHeightAligned = resultHeight;
                            padding = 0;
                            bufferSize = resultWidth * resultHeight * 3 / 2;
                            if (processorType == 0) {
                                if (resultHeight % 16 != 0) {
                                    padding = resultWidth * ((resultHeightAligned += 16 - resultHeight % 16) - resultHeight);
                                    bufferSize += padding * 5 / 4;
                                }
                            } else if (processorType == 1) {
                                if (!manufacturer.toLowerCase().equals("lge")) {
                                    uvoffset = resultWidth * resultHeight + 2047 & -2048;
                                    padding = uvoffset - resultWidth * resultHeight;
                                    bufferSize += padding;
                                }
                            } else if (processorType != 5 && processorType == 3 && manufacturer.equals("baidu")) {
                                padding = resultWidth * ((resultHeightAligned += 16 - resultHeight % 16) - resultHeight);
                                bufferSize += padding * 5 / 4;
                            }
                            extractor.selectTrack(videoIndex);
                            if (startTime > 0L) {
                                extractor.seekTo(startTime, 0);
                            } else {
                                extractor.seekTo(0L, 0);
                            }
                            inputFormat = extractor.getTrackFormat(videoIndex);
                            outputFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)resultWidth, (int)resultHeight);
                            outputFormat.setInteger("color-format", colorFormat);
                            outputFormat.setInteger("bitrate", bitrate);
                            outputFormat.setInteger("frame-rate", 25);
                            outputFormat.setInteger("i-frame-interval", 10);
                            if (Build.VERSION.SDK_INT < 18) {
                                outputFormat.setInteger("stride", resultWidth + 32);
                                outputFormat.setInteger("slice-height", resultHeight);
                            }
                            encoder = MediaCodec.createEncoderByType((String)"video/avc");
                            encoder.configure(outputFormat, null, null, 1);
                            if (Build.VERSION.SDK_INT >= 18) {
                                inputSurface = new InputSurface(encoder.createInputSurface());
                                inputSurface.makeCurrent();
                            }
                            encoder.start();
                            decoder = MediaCodec.createDecoderByType((String)inputFormat.getString("mime"));
                            outputSurface = Build.VERSION.SDK_INT >= 18 ? new OutputSurface() : new OutputSurface(resultWidth, resultHeight, rotateRender);
                            decoder.configure(inputFormat, outputSurface.getSurface(), null, 0);
                            decoder.start();
                            TIMEOUT_USEC = 2500;
                            decoderInputBuffers = null;
                            encoderOutputBuffers = null;
                            encoderInputBuffers = null;
                            if (Build.VERSION.SDK_INT < 21) {
                                decoderInputBuffers = decoder.getInputBuffers();
                                encoderOutputBuffers = encoder.getOutputBuffers();
                                if (Build.VERSION.SDK_INT < 18) {
                                    encoderInputBuffers = encoder.getInputBuffers();
                                }
                            }
                            while (!outputDone) {
                                if (!inputDone) {
                                    eof = false;
                                    index = extractor.getSampleTrackIndex();
                                    if (index == videoIndex) {
                                        inputBufIndex = decoder.dequeueInputBuffer(2500L);
                                        if (inputBufIndex >= 0) {
                                            inputBuf = Build.VERSION.SDK_INT < 21 ? decoderInputBuffers[inputBufIndex] : decoder.getInputBuffer(inputBufIndex);
                                            chunkSize = extractor.readSampleData(inputBuf, 0);
                                            if (chunkSize < 0) {
                                                decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                                inputDone = true;
                                            } else {
                                                decoder.queueInputBuffer(inputBufIndex, 0, chunkSize, extractor.getSampleTime(), 0);
                                                extractor.advance();
                                            }
                                        }
                                    } else if (index == -1) {
                                        eof = true;
                                    }
                                    if (eof && (inputBufIndex = decoder.dequeueInputBuffer(2500L)) >= 0) {
                                        decoder.queueInputBuffer(inputBufIndex, 0, 0, 0L, 4);
                                        inputDone = true;
                                    }
                                }
                                decoderOutputAvailable = decoderDone == false;
                                encoderOutputAvailable = true;
                                while (decoderOutputAvailable || encoderOutputAvailable) {
                                    encoderStatus = encoder.dequeueOutputBuffer(info, 2500L);
                                    if (encoderStatus == -1) {
                                        encoderOutputAvailable = false;
                                    } else if (encoderStatus == -3) {
                                        if (Build.VERSION.SDK_INT < 21) {
                                            encoderOutputBuffers = encoder.getOutputBuffers();
                                        }
                                    } else if (encoderStatus == -2) {
                                        newFormat = encoder.getOutputFormat();
                                        if (videoTrackIndex == -5) {
                                            videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                        }
                                    } else {
                                        if (encoderStatus < 0) {
                                            throw new RuntimeException("unexpected result from encoder.dequeueOutputBuffer: " + encoderStatus);
                                        }
                                        encodedData = Build.VERSION.SDK_INT < 21 ? encoderOutputBuffers[encoderStatus] : encoder.getOutputBuffer(encoderStatus);
                                        if (encodedData == null) {
                                            throw new RuntimeException("encoderOutputBuffer " + encoderStatus + " was null");
                                        }
                                        if (info.size > 1) {
                                            if ((info.flags & 2) == 0) {
                                                if (mediaMuxer.writeSampleData(videoTrackIndex, encodedData, info, false)) {
                                                    this.didWriteData(false, false);
                                                }
                                            } else if (videoTrackIndex == -5) {
                                                csd = new byte[info.size];
                                                encodedData.limit(info.offset + info.size);
                                                encodedData.position(info.offset);
                                                encodedData.get(csd);
                                                sps = null;
                                                pps = null;
                                                for (a = info.size - 1; a >= 0 && a > 3; --a) {
                                                    if (csd[a] != 1 || csd[a - 1] != 0 || csd[a - 2] != 0 || csd[a - 3] != 0) continue;
                                                    sps = ByteBuffer.allocate(a - 3);
                                                    pps = ByteBuffer.allocate(info.size - (a - 3));
                                                    sps.put(csd, 0, a - 3).position(0);
                                                    pps.put(csd, a - 3, info.size - (a - 3)).position(0);
                                                    break;
                                                }
                                                newFormat = MediaFormat.createVideoFormat((String)"video/avc", (int)resultWidth, (int)resultHeight);
                                                if (sps != null && pps != null) {
                                                    newFormat.setByteBuffer("csd-0", sps);
                                                    newFormat.setByteBuffer("csd-1", pps);
                                                }
                                                videoTrackIndex = mediaMuxer.addTrack(newFormat, false);
                                            }
                                        }
                                        outputDone = (info.flags & 4) != 0;
                                        encoder.releaseOutputBuffer(encoderStatus, false);
                                    }
                                    if (encoderStatus != -1 || decoderDone) continue;
                                    decoderStatus = decoder.dequeueOutputBuffer(info, 2500L);
                                    if (decoderStatus == -1) {
                                        decoderOutputAvailable = false;
                                        continue;
                                    }
                                    if (decoderStatus == -3) continue;
                                    if (decoderStatus == -2) {
                                        newFormat = decoder.getOutputFormat();
                                        Log.e((String)"tmessages", (String)("newFormat = " + newFormat));
                                        continue;
                                    }
                                    if (decoderStatus < 0) {
                                        throw new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: " + decoderStatus);
                                    }
                                    if (Build.VERSION.SDK_INT >= 18) {
                                        doRender = info.size != 0;
                                    } else {
                                        v0 = doRender = info.size != 0 || info.presentationTimeUs != 0L;
                                    }
                                    if (endTime > 0L && info.presentationTimeUs >= endTime) {
                                        inputDone = true;
                                        decoderDone = true;
                                        doRender = false;
                                        info.flags |= 4;
                                    }
                                    if (startTime > 0L && videoTime == -1L) {
                                        if (info.presentationTimeUs < startTime) {
                                            doRender = false;
                                            Log.e((String)"tmessages", (String)("drop frame startTime = " + startTime + " present time = " + info.presentationTimeUs));
                                        } else {
                                            videoTime = info.presentationTimeUs;
                                        }
                                    }
                                    decoder.releaseOutputBuffer(decoderStatus, doRender);
                                    if (doRender) {
                                        errorWait = false;
                                        try {
                                            outputSurface.awaitNewImage();
                                        }
                                        catch (Exception e) {
                                            errorWait = true;
                                            Log.e((String)"tmessages", (String)e.getMessage());
                                        }
                                        if (!errorWait) {
                                            if (Build.VERSION.SDK_INT >= 18) {
                                                outputSurface.drawImage(false);
                                                inputSurface.setPresentationTime(info.presentationTimeUs * 1000L);
                                                if (listener != null) {
                                                    listener.onProgress((float)info.presentationTimeUs / (float)duration * 100.0f);
                                                }
                                                inputSurface.swapBuffers();
                                            } else {
                                                inputBufIndex = encoder.dequeueInputBuffer(2500L);
                                                if (inputBufIndex >= 0) {
                                                    outputSurface.drawImage(true);
                                                    rgbBuf = outputSurface.getFrame();
                                                    yuvBuf = encoderInputBuffers[inputBufIndex];
                                                    yuvBuf.clear();
                                                    VideoController.convertVideoFrame(rgbBuf, yuvBuf, colorFormat, resultWidth, resultHeight, padding, swapUV);
                                                    encoder.queueInputBuffer(inputBufIndex, 0, bufferSize, info.presentationTimeUs, 0);
                                                } else {
                                                    Log.e((String)"tmessages", (String)"input buffer not available");
                                                }
                                            }
                                        }
                                    }
                                    if ((info.flags & 4) == 0) continue;
                                    decoderOutputAvailable = false;
                                    Log.e((String)"tmessages", (String)"decoder stream end");
                                    if (Build.VERSION.SDK_INT >= 18) {
                                        encoder.signalEndOfInputStream();
                                        continue;
                                    }
                                    inputBufIndex = encoder.dequeueInputBuffer(2500L);
                                    if (inputBufIndex < 0) continue;
                                    encoder.queueInputBuffer(inputBufIndex, 0, 1, info.presentationTimeUs, 4);
                                }
                            }
                            if (videoTime != -1L) {
                                videoStartTime = videoTime;
                            }
                        }
                        catch (Exception e) {
                            Log.e((String)"tmessages", (String)e.getMessage());
                            error = true;
                        }
                        extractor.unselectTrack(videoIndex);
                        if (outputSurface != null) {
                            outputSurface.release();
                        }
                        if (inputSurface != null) {
                            inputSurface.release();
                        }
                        if (decoder != null) {
                            decoder.stop();
                            decoder.release();
                        }
                        if (encoder != null) {
                            encoder.stop();
                            encoder.release();
                        }
                    }
                } else {
                    videoTime = this.readAndWriteTrack(extractor, mediaMuxer, info, startTime, endTime, cacheFile, false);
                    if (videoTime != -1L) {
                        videoStartTime = videoTime;
                    }
                }
                if (error) ** GOTO lbl370
                this.readAndWriteTrack(extractor, mediaMuxer, info, videoStartTime, endTime, cacheFile, true);
            }
            catch (Exception e) {
                error = true;
                Log.e((String)"tmessages", (String)e.getMessage());
            }
            finally {
                if (extractor != null) {
                    extractor.release();
                }
                if (mediaMuxer != null) {
                    try {
                        mediaMuxer.finishMovie(false);
                    }
                    catch (Exception e) {
                        Log.e((String)"tmessages", (String)e.getMessage());
                    }
                }
                Log.e((String)"tmessages", (String)("time = " + (System.currentTimeMillis() - time)));
            }
        } else {
            this.didWriteData(true, true);
            return false;
        }
lbl370:
        // 3 sources

        this.didWriteData(true, error);
        VideoController.cachedFile = cacheFile;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dst) throws IOException {
        FileChannel inChannel = new FileInputStream(src).getChannel();
        FileChannel outChannel = new FileOutputStream(dst).getChannel();
        try {
            inChannel.transferTo(1L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    static {
        Instance = null;
    }

    public static class VideoConvertRunnable
    implements Runnable {
        private String videoPath;
        private String destPath;

        private VideoConvertRunnable(String videoPath, String destPath) {
            this.videoPath = videoPath;
            this.destPath = destPath;
        }

        public static void runConversion(final String videoPath, final String destPath) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        VideoConvertRunnable wrapper = new VideoConvertRunnable(videoPath, destPath);
                        Thread th = new Thread((Runnable)wrapper, "VideoConvertRunnable");
                        th.start();
                        th.join();
                    }
                    catch (Exception e) {
                        Log.e((String)"tmessages", (String)e.getMessage());
                    }
                }
            }).start();
        }

        @Override
        public void run() {
            VideoController.getInstance().convertVideo(this.videoPath, this.destPath, 0, null);
        }
    }

    static interface CompressProgressListener {
        public void onProgress(float var1);
    }
}

