/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.videocompressor;

import android.os.AsyncTask;
import com.publit.publit_io.videocompressor.VideoController;

public class VideoCompress {
    private static final String TAG = VideoCompress.class.getSimpleName();

    public static VideoCompressTask compressVideoHigh(String srcPath, String destPath, CompressListener listener) {
        VideoCompressTask task = new VideoCompressTask(listener, 1);
        task.execute(new String[]{srcPath, destPath});
        return task;
    }

    public static VideoCompressTask compressVideoMedium(String srcPath, String destPath, CompressListener listener) {
        VideoCompressTask task = new VideoCompressTask(listener, 2);
        task.execute(new String[]{srcPath, destPath});
        return task;
    }

    public static VideoCompressTask compressVideoLow(String srcPath, String destPath, CompressListener listener) {
        VideoCompressTask task = new VideoCompressTask(listener, 3);
        task.execute(new String[]{srcPath, destPath});
        return task;
    }

    public static interface CompressListener {
        public void onStart();

        public void onSuccess();

        public void onFail();

        public void onProgress(float var1);
    }

    private static class VideoCompressTask
    extends AsyncTask<String, Float, Boolean> {
        private CompressListener mListener;
        private int mQuality;

        public VideoCompressTask(CompressListener listener, int quality) {
            this.mListener = listener;
            this.mQuality = quality;
        }

        protected void onPreExecute() {
            super.onPreExecute();
            if (this.mListener != null) {
                this.mListener.onStart();
            }
        }

        protected Boolean doInBackground(String ... paths) {
            return VideoController.getInstance().convertVideo(paths[0], paths[1], this.mQuality, new VideoController.CompressProgressListener(){

                @Override
                public void onProgress(float percent) {
                    VideoCompressTask.this.publishProgress(new Float[]{Float.valueOf(percent)});
                }
            });
        }

        protected void onProgressUpdate(Float ... percent) {
            super.onProgressUpdate((Object[])percent);
            if (this.mListener != null) {
                this.mListener.onProgress(percent[0].floatValue());
            }
        }

        protected void onPostExecute(Boolean result) {
            super.onPostExecute((Object)result);
            if (this.mListener != null) {
                if (result.booleanValue()) {
                    this.mListener.onSuccess();
                } else {
                    this.mListener.onFail();
                }
            }
        }
    }
}

