/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.players;

import android.content.Context;
import com.google.gson.JsonObject;
import com.publit.publit_io.R;
import com.publit.publit_io.api.APIClient;
import com.publit.publit_io.api.ApiInterface;
import com.publit.publit_io.utils.APIConfiguration;
import com.publit.publit_io.utils.NetworkService;
import com.publit.publit_io.utils.PublitioCallback;
import com.publit.publit_io.utils.SHAGenerator;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PublitioPlayers {
    private Context mContext;

    public PublitioPlayers(Context activity) {
        this.mContext = activity;
    }

    public void createPlayer(String playerName, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (playerName == null) {
            callback.failure(this.mContext.getString(R.string.provide_player_name));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callCreatePlayer(playerName, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void playersList(final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callPlayersList(apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void showPlayer(String playerID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callShowPlayer(playerID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void updatePlayer(String playerID, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (playerID == null) {
            callback.failure(this.mContext.getString(R.string.provide_player_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callUpdatePlayer(playerID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void deletePlayer(String playerID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callDeletePlayer(playerID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    private boolean isValidated(PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiSecret == null || APIConfiguration.apiSecret.isEmpty() || APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            callback.failure(this.mContext.getResources().getString(R.string.key_or_secret_not_found));
            return false;
        }
        return true;
    }
}

