/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.files;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.publit.publit_io.R;
import com.publit.publit_io.api.APIClient;
import com.publit.publit_io.api.ApiInterface;
import com.publit.publit_io.api.request.ProgressRequestBody;
import com.publit.publit_io.constant.Constant;
import com.publit.publit_io.exception.PublitioExceptions;
import com.publit.publit_io.utils.APIConfiguration;
import com.publit.publit_io.utils.FileUtils;
import com.publit.publit_io.utils.LogUtils;
import com.publit.publit_io.utils.NetworkService;
import com.publit.publit_io.utils.PublitioCallback;
import com.publit.publit_io.utils.SHAGenerator;
import com.publit.publit_io.videocompressor.VideoCompress;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PublitioFiles
implements ProgressRequestBody.UploadCallbacks {
    private Context mContext;
    private String fileName;

    public PublitioFiles(Context context) {
        this.mContext = context;
    }

    public void filesList(Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callFilesList(apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), t.getMessage());
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void showFile(String fileID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callShowFile(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), new Gson().toJson((Object)t.getMessage()));
                    callback.failure(new Gson().toJson((Object)t.getMessage()));
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void updateFile(String fileID, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callUpdateFile(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), new Gson().toJson((Object)t.getMessage()));
                    callback.failure(new Gson().toJson((Object)t.getMessage()));
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void deleteFile(String fileID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callDeleteFie(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), new Gson().toJson((Object)t.getMessage()));
                    callback.failure(new Gson().toJson((Object)t.getMessage()));
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void uploadFile(Uri fileUri, Map<String, String> optionalParams, PublitioCallback<JsonObject> callback) throws PublitioExceptions {
        if (fileUri == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_uri));
            return;
        }
        File file = FileUtils.getFile(this.mContext, fileUri);
        String resolution = "";
        ContentResolver cR = this.mContext.getContentResolver();
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String type = mime.getExtensionFromMimeType(cR.getType(fileUri));
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                if (!entry.getKey().equals("resolution") || type == null || type.isEmpty() || !type.equals("mp4") && !type.equals("webm") && !type.equals("ogv") && !type.equals("avi") && !type.equals("mov") && !type.equals("flv") && !type.equals("3gp") && !type.equals("3g2") && !type.equals("wmv") && !type.equals("mpeg") && !type.equals("mkv")) continue;
                resolution = entry.getValue();
                Constant.IS_COMPRESSED_VIDEO = true;
            }
        }
        if (Constant.IS_COMPRESSED_VIDEO) {
            this.compressVideo(file, resolution, optionalParams, callback);
        } else {
            this.uploadFileOnServer(fileUri, optionalParams, callback);
        }
    }

    private void compressVideo(final File file, String resolution, final Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        final File mydir = new File(this.mContext.getFilesDir(), "");
        this.fileName = file.getName();
        if (resolution.equals("low")) {
            VideoCompress.compressVideoLow(file.getAbsolutePath(), mydir.getAbsolutePath() + "/" + this.fileName, new VideoCompress.CompressListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onSuccess() {
                    PublitioFiles.this.uploadFileOnServer(Uri.fromFile((File)new File(mydir.getAbsolutePath() + "/" + file.getName())), optionalParams, callback);
                }

                @Override
                public void onFail() {
                }

                @Override
                public void onProgress(float percent) {
                }
            });
        } else {
            VideoCompress.compressVideoMedium(file.getAbsolutePath(), mydir.getAbsolutePath() + "/" + this.fileName, new VideoCompress.CompressListener(){

                @Override
                public void onStart() {
                }

                @Override
                public void onSuccess() {
                    PublitioFiles.this.uploadFileOnServer(Uri.fromFile((File)new File(mydir.getAbsolutePath() + "/" + file.getName())), optionalParams, callback);
                }

                @Override
                public void onFail() {
                }

                @Override
                public void onProgress(float percent) {
                }
            });
        }
    }

    private void uploadFileOnServer(Uri fileUri, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        SHAGenerator shaGenerator = new SHAGenerator();
        File file = FileUtils.getFile(this.mContext, fileUri);
        String type = this.getFileExtention(fileUri);
        ProgressRequestBody fileBody = new ProgressRequestBody(file, type, this);
        MultipartBody.Part fileData = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callCreateFile(fileData, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        if (Constant.IS_COMPRESSED_VIDEO) {
                            Constant.IS_COMPRESSED_VIDEO = false;
                        }
                        PublitioFiles.this.deleteCompressedFile();
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), t.getMessage());
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    private String getFileExtention(Uri fileUri) {
        String type;
        String[] arr = new String[]{};
        if (this.fileName != null && !this.fileName.isEmpty()) {
            arr = this.fileName.split("\\.");
        }
        if (Constant.IS_COMPRESSED_VIDEO) {
            type = arr[1];
        } else {
            ContentResolver cR = this.mContext.getContentResolver();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            type = mime.getExtensionFromMimeType(cR.getType(fileUri));
        }
        return type;
    }

    private void deleteCompressedFile() {
        if (this.fileName != null && !this.fileName.isEmpty()) {
            File dir = this.mContext.getFilesDir();
            File file = new File(dir, this.fileName);
            file.delete();
        }
    }

    @Override
    public void onProgressUpdate(int percentage) {
    }

    @Override
    public void onError() {
    }

    @Override
    public void onFinish() {
    }

    private boolean isValidated(PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiSecret == null || APIConfiguration.apiSecret.isEmpty() || APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            callback.failure(this.mContext.getResources().getString(R.string.key_or_secret_not_found));
            return false;
        }
        return true;
    }
}

