/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.api.request;

import android.os.Handler;
import android.os.Looper;
import android.webkit.MimeTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class ProgressRequestBody
extends RequestBody {
    private File mFile;
    private UploadCallbacks mListener;
    private String mExtensionType;
    private static final int DEFAULT_BUFFER_SIZE = 2048;

    public ProgressRequestBody(File file, String extensionType, UploadCallbacks listener) {
        this.mFile = file;
        this.mExtensionType = extensionType;
        this.mListener = listener;
    }

    public MediaType contentType() {
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        mime.getMimeTypeFromExtension(this.mExtensionType.toLowerCase());
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(this.mExtensionType.toLowerCase());
        return MediaType.parse((String)mimeType);
    }

    public long contentLength() throws IOException {
        return this.mFile.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(BufferedSink sink) throws IOException {
        long fileLength = this.mFile.length();
        byte[] buffer = new byte[2048];
        long uploaded = 0L;
        try (FileInputStream in = new FileInputStream(this.mFile);){
            int read;
            Handler handler = new Handler(Looper.getMainLooper());
            while ((read = in.read(buffer)) != -1) {
                handler.post((Runnable)new ProgressUpdater(uploaded, fileLength));
                uploaded += (long)read;
                sink.write(buffer, 0, read);
            }
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private long mUploaded;
        private long mTotal;

        public ProgressUpdater(long uploaded, long total) {
            this.mUploaded = uploaded;
            this.mTotal = total;
        }

        @Override
        public void run() {
            ProgressRequestBody.this.mListener.onProgressUpdate((int)(100L * this.mUploaded / this.mTotal));
        }
    }

    public static interface UploadCallbacks {
        public void onProgressUpdate(int var1);

        public void onError();

        public void onFinish();
    }
}

