/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.api;

import com.publit.publit_io.api.ErrorResponseParser;
import com.publit.publit_io.api.response.ErrorResponse;
import com.publit.publit_io.utils.LogUtils;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public abstract class AbstractCallback<T>
implements Callback<T> {
    private final String TAG = LogUtils.makeLogTag(this.getClass());
    private ErrorResponseParser errorResponseParser = new ErrorResponseParser();

    public void onResponse(Call<T> call, Response<T> response) {
        if (response.code() >= 400) {
            this.onResponseError(call, response);
        } else {
            this.handleSuccess(response);
        }
        this.handleComplete(call);
    }

    public void onFailure(Call<T> call, Throwable t) {
        LogUtils.LOGE(this.TAG, t.getMessage(), t);
        this.handleFailure(call, t);
        this.handleComplete(call);
    }

    private ErrorResponse doParseError(Response<T> response) {
        return this.errorResponseParser.parse(response);
    }

    protected void onResponseError(Call<T> call, Response<T> response) {
        ErrorResponse errorResponse = this.doParseError(response);
        LogUtils.LOGD(AbstractCallback.class.getSimpleName(), call.request().url().toString());
        switch (response.code()) {
            case 400: {
                this.handleClientError(errorResponse);
                break;
            }
            default: {
                this.handleError(call, errorResponse);
            }
        }
    }

    protected void handleClientError(ErrorResponse errorResponse) {
    }

    protected void handleComplete(Call<T> call) {
    }

    protected abstract void handleFailure(Call<T> var1, Throwable var2);

    protected abstract void handleError(Call<T> var1, ErrorResponse var2);

    protected abstract void handleSuccess(Response<T> var1);
}

