/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.versions;

import android.content.Context;
import com.google.gson.JsonObject;
import com.publit.publit_io.R;
import com.publit.publit_io.api.APIClient;
import com.publit.publit_io.api.ApiInterface;
import com.publit.publit_io.utils.APIConfiguration;
import com.publit.publit_io.utils.NetworkService;
import com.publit.publit_io.utils.PublitioCallback;
import com.publit.publit_io.utils.SHAGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PublitioVersions {
    private Context mContext;

    public PublitioVersions(Context activity) {
        this.mContext = activity;
    }

    public void createVersion(String fileId, String outputFormat, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        Iterator stringIterator;
        if (!this.isValidated(callback)) {
            return;
        }
        if (fileId == null || outputFormat == null) {
            callback.failure(this.mContext.getString(R.string.provide_output_format));
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        SHAGenerator shaGenerator = new SHAGenerator();
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            if (optionalParams.get("resizing_width") != null && !optionalParams.get("resizing_width").isEmpty()) {
                strings.add("w_" + optionalParams.get("resizing_width"));
            }
            if (optionalParams.get("resizing_height") != null && !optionalParams.get("resizing_height").isEmpty()) {
                strings.add("h_" + optionalParams.get("resizing_height"));
            }
            if (optionalParams.get("cropping") != null && !optionalParams.get("cropping").isEmpty()) {
                strings.add(optionalParams.get("cropping"));
            }
            if (optionalParams.get("watermarking") != null && !optionalParams.get("watermarking").isEmpty()) {
                strings.add("wm_" + optionalParams.get("watermarking"));
            }
            if (optionalParams.get("quality") != null && !optionalParams.get("quality").isEmpty()) {
                strings.add("q_" + optionalParams.get("quality"));
            }
            if (optionalParams.get("trimming_time") != null && !optionalParams.get("trimming_time").isEmpty()) {
                strings.add("t_" + optionalParams.get("trimming_time"));
            }
            if (optionalParams.get("trimming_start") != null && !optionalParams.get("trimming_start").isEmpty()) {
                strings.add("so_" + optionalParams.get("trimming_start"));
            }
            if (optionalParams.get("trimming_end") != null && !optionalParams.get("trimming_end").isEmpty()) {
                strings.add("eo_" + optionalParams.get("trimming_end"));
            }
        }
        if (strings.size() > 0 && (stringIterator = strings.iterator()).hasNext()) {
            StringBuilder buffer = new StringBuilder((String)stringIterator.next());
            while (stringIterator.hasNext()) {
                buffer.append(",").append((String)stringIterator.next());
            }
            apiParams.put("options", buffer.toString());
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callCreateVersion(fileId, outputFormat, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void versionsList(String fileID, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        SHAGenerator shaGenerator = new SHAGenerator();
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callVersionsList(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void showVersion(String versionID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (versionID == null || versionID.isEmpty()) {
            callback.failure(this.mContext.getString(R.string.provide_version_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callShowVersion(versionID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void updateVersion(String versionID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (versionID == null || versionID.isEmpty()) {
            callback.failure(this.mContext.getString(R.string.provide_version_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callUpdateVersion(versionID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void reconvertVersion(String versionID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (versionID == null || versionID.isEmpty()) {
            callback.failure(this.mContext.getString(R.string.provide_version_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callReconvertVersion(versionID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void deleteVersion(String versionID, final PublitioCallback<JsonObject> callback) {
        if (!this.isValidated(callback)) {
            return;
        }
        if (versionID == null || versionID.isEmpty()) {
            callback.failure(this.mContext.getString(R.string.provide_version_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        apiParams.put("api_kit", "android");
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callDeleteVersion(versionID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    private boolean isValidated(PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiSecret == null || APIConfiguration.apiSecret.isEmpty() || APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            callback.failure(this.mContext.getResources().getString(R.string.key_or_secret_not_found));
            return false;
        }
        return true;
    }
}

