/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.utils;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.webkit.MimeTypeMap;
import com.publit.publit_io.utils.LogUtils;
import java.io.File;
import java.io.FileFilter;
import java.text.DecimalFormat;
import java.util.Comparator;

public class FileUtils {
    static final String TAG = "FileUtils";
    private static final boolean DEBUG = false;
    public static final String MIME_TYPE_AUDIO = "audio/*";
    public static final String MIME_TYPE_TEXT = "text/*";
    public static final String MIME_TYPE_IMAGE = "image/*";
    public static final String MIME_TYPE_VIDEO = "video/*";
    public static final String MIME_TYPE_APP = "application/*";
    public static final String HIDDEN_PREFIX = ".";
    public static Comparator<File> sComparator = new Comparator<File>(){

        @Override
        public int compare(File f1, File f2) {
            return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
        }
    };
    public static FileFilter sFileFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            return file.isFile() && !fileName.startsWith(FileUtils.HIDDEN_PREFIX);
        }
    };
    public static FileFilter sDirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            String fileName = file.getName();
            return file.isDirectory() && !fileName.startsWith(FileUtils.HIDDEN_PREFIX);
        }
    };

    private FileUtils() {
    }

    public static String getExtension(String uri) {
        if (uri == null) {
            return null;
        }
        int dot = uri.lastIndexOf(HIDDEN_PREFIX);
        if (dot >= 0) {
            return uri.substring(dot);
        }
        return "";
    }

    public static boolean isLocal(String url) {
        return url != null && !url.startsWith("http://") && !url.startsWith("https://");
    }

    public static boolean isMediaUri(Uri uri) {
        return "media".equalsIgnoreCase(uri.getAuthority());
    }

    public static Uri getUri(File file) {
        if (file != null) {
            return Uri.fromFile((File)file);
        }
        return null;
    }

    public static File getPathWithoutFilename(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return file;
            }
            String filename = file.getName();
            String filepath = file.getAbsolutePath();
            String pathwithoutname = filepath.substring(0, filepath.length() - filename.length());
            if (pathwithoutname.endsWith("/")) {
                pathwithoutname = pathwithoutname.substring(0, pathwithoutname.length() - 1);
            }
            return new File(pathwithoutname);
        }
        return null;
    }

    public static String getMimeType(File file) {
        String extension = FileUtils.getExtension(file.getName());
        if (extension.length() > 0) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension.substring(1));
        }
        return "application/octet-stream";
    }

    public static String getMimeType(Context context, Uri uri) {
        File file = new File(FileUtils.getPath(context, uri));
        return FileUtils.getMimeType(file);
    }

    public static boolean isLocalStorageDocument(Uri uri) {
        return "com.publit.publit_io.localstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isExternalStorageDocument(Uri uri) {
        return "com.android.externalstorage.documents".equals(uri.getAuthority());
    }

    public static boolean isDownloadsDocument(Uri uri) {
        return "com.android.providers.downloads.documents".equals(uri.getAuthority());
    }

    public static boolean isMediaDocument(Uri uri) {
        return "com.android.providers.media.documents".equals(uri.getAuthority());
    }

    public static boolean isGooglePhotosUri(Uri uri) {
        return "com.google.android.apps.photos.content".equals(uri.getAuthority());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDataColumn(Context context, Uri uri, String selection, String[] selectionArgs) {
        Cursor cursor = null;
        String column = "_data";
        String[] projection = new String[]{"_data"};
        try {
            cursor = context.getContentResolver().query(uri, projection, selection, selectionArgs, null);
            if (cursor != null && cursor.moveToFirst()) {
                int column_index = cursor.getColumnIndexOrThrow("_data");
                String string2 = cursor.getString(column_index);
                return string2;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return null;
    }

    public static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && DocumentsContract.isDocumentUri((Context)context, (Uri)uri)) {
            if (FileUtils.isLocalStorageDocument(uri)) {
                return DocumentsContract.getDocumentId((Uri)uri);
            }
            if (FileUtils.isExternalStorageDocument(uri)) {
                String docId = DocumentsContract.getDocumentId((Uri)uri);
                String[] split = docId.split(":");
                String type = split[0];
                if ("primary".equalsIgnoreCase(type)) {
                    return Environment.getExternalStorageDirectory() + "/" + split[1];
                }
            } else {
                if (FileUtils.isDownloadsDocument(uri)) {
                    String id = DocumentsContract.getDocumentId((Uri)uri);
                    Uri contentUri = ContentUris.withAppendedId((Uri)Uri.parse((String)"content://downloads/public_downloads"), (long)Long.valueOf(id));
                    return FileUtils.getDataColumn(context, contentUri, null, null);
                }
                if (FileUtils.isMediaDocument(uri)) {
                    String docId = DocumentsContract.getDocumentId((Uri)uri);
                    String[] split = docId.split(":");
                    String type = split[0];
                    Uri contentUri = null;
                    if ("image".equals(type)) {
                        contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                    } else if ("video".equals(type)) {
                        contentUri = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    } else if ("audio".equals(type)) {
                        contentUri = MediaStore.Audio.Media.EXTERNAL_CONTENT_URI;
                    }
                    String selection = "_id=?";
                    String[] selectionArgs = new String[]{split[1]};
                    return FileUtils.getDataColumn(context, contentUri, "_id=?", selectionArgs);
                }
            }
        } else {
            if ("content".equalsIgnoreCase(uri.getScheme())) {
                if (FileUtils.isGooglePhotosUri(uri)) {
                    return uri.getLastPathSegment();
                }
                return FileUtils.getDataColumn(context, uri, null, null);
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return uri.getPath();
            }
        }
        return null;
    }

    public static File getFile(Context context, Uri uri) {
        String path;
        if (uri != null && (path = FileUtils.getPath(context, uri)) != null && FileUtils.isLocal(path)) {
            return new File(path);
        }
        return null;
    }

    public static String getReadableFileSize(int size) {
        int BYTES_IN_KILOBYTES = 1024;
        DecimalFormat dec = new DecimalFormat("###.#");
        String KILOBYTES = " KB";
        String MEGABYTES = " MB";
        String GIGABYTES = " GB";
        float fileSize = 0.0f;
        String suffix = " KB";
        if (size > 1024 && (fileSize = (float)(size / 1024)) > 1024.0f) {
            if ((fileSize /= 1024.0f) > 1024.0f) {
                fileSize /= 1024.0f;
                suffix = " GB";
            } else {
                suffix = " MB";
            }
        }
        return String.valueOf(dec.format(fileSize) + suffix);
    }

    public static Bitmap getThumbnail(Context context, File file) {
        return FileUtils.getThumbnail(context, FileUtils.getUri(file), FileUtils.getMimeType(file));
    }

    public static Bitmap getThumbnail(Context context, Uri uri) {
        return FileUtils.getThumbnail(context, uri, FileUtils.getMimeType(context, uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getThumbnail(Context context, Uri uri, String mimeType) {
        if (!FileUtils.isMediaUri(uri)) {
            LogUtils.LOGE(FileUtils.class.getSimpleName(), "You can only retrieve thumbnails for images and videos.");
            return null;
        }
        Bitmap bm = null;
        if (uri != null) {
            ContentResolver resolver = context.getContentResolver();
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, null, null, null, null);
                if (cursor.moveToFirst()) {
                    int id = cursor.getInt(0);
                    if (mimeType.contains("video")) {
                        bm = MediaStore.Video.Thumbnails.getThumbnail((ContentResolver)resolver, (long)id, (int)1, null);
                    } else if (mimeType.contains(MIME_TYPE_IMAGE)) {
                        bm = MediaStore.Images.Thumbnails.getThumbnail((ContentResolver)resolver, (long)id, (int)1, null);
                    }
                }
            }
        }
        return bm;
    }

    public static Intent createGetContentIntent() {
        Intent intent = new Intent("android.intent.action.GET_CONTENT");
        intent.setType("*/*");
        intent.addCategory("android.intent.category.OPENABLE");
        return intent;
    }
}

