/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.utils;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.widget.Toast;
import com.publit.publit_io.R;
import com.publit.publit_io.exception.PublitioExceptions;

public class APIConfiguration {
    public static String apiSecret;
    public static String apiKey;
    private Activity mActivity;

    protected APIConfiguration(Activity activity) {
        this.mActivity = activity;
        this.readMetaData();
    }

    private void readMetaData() {
        try {
            ApplicationInfo ai = this.mActivity.getPackageManager().getApplicationInfo(this.mActivity.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            apiKey = bundle.getString("publitio_api_key");
            apiSecret = bundle.getString("publitio_api_secret");
        }
        catch (PackageManager.NameNotFoundException e) {
            new PublitioExceptions(this.mActivity.getString(R.string.key_or_secret_not_found));
        }
        catch (NullPointerException e) {
            new PublitioExceptions(this.mActivity.getString(R.string.failed_to_load_meta_data));
        }
        if (apiSecret == null || apiSecret.isEmpty() || apiKey == null || apiKey.isEmpty()) {
            Toast.makeText((Context)this.mActivity, (CharSequence)this.mActivity.getString(R.string.key_or_secret_not_found), (int)1).show();
        }
    }
}

