/*
 * Decompiled with CFR 0.152.
 */
package com.publit.publit_io.files;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.publit.publit_io.R;
import com.publit.publit_io.api.APIClient;
import com.publit.publit_io.api.ApiInterface;
import com.publit.publit_io.api.request.ProgressRequestBody;
import com.publit.publit_io.utils.APIConfiguration;
import com.publit.publit_io.utils.FileUtils;
import com.publit.publit_io.utils.LogUtils;
import com.publit.publit_io.utils.NetworkService;
import com.publit.publit_io.utils.PublitioCallback;
import com.publit.publit_io.utils.SHAGenerator;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PublitioFiles
implements ProgressRequestBody.UploadCallbacks {
    private Context mContext;

    public PublitioFiles(Context context) {
        this.mContext = context;
    }

    public void filesList(Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callFilesList(apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), t.getMessage());
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void showFile(String fileID, final PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callShowFile(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), new Gson().toJson((Object)t.getMessage()));
                    callback.failure(new Gson().toJson((Object)t.getMessage()));
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void updateFile(String fileID, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callUpdateFile(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), new Gson().toJson((Object)t.getMessage()));
                    callback.failure(new Gson().toJson((Object)t.getMessage()));
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void deleteFile(String fileID, final PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            return;
        }
        if (fileID == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_id));
            return;
        }
        SHAGenerator shaGenerator = new SHAGenerator();
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callDeleteFie(fileID, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), new Gson().toJson((Object)t.getMessage()));
                    callback.failure(new Gson().toJson((Object)t.getMessage()));
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    public void uploadFile(Uri fileUri, Map<String, String> optionalParams, final PublitioCallback<JsonObject> callback) {
        if (APIConfiguration.apiKey == null || APIConfiguration.apiKey.isEmpty()) {
            return;
        }
        ApiInterface apiService = (ApiInterface)APIClient.getClient().create(ApiInterface.class);
        SHAGenerator shaGenerator = new SHAGenerator();
        if (fileUri == null) {
            callback.failure(this.mContext.getString(R.string.provide_file_uri));
            return;
        }
        File file = FileUtils.getFile(this.mContext, fileUri);
        ContentResolver cR = this.mContext.getContentResolver();
        MimeTypeMap mime = MimeTypeMap.getSingleton();
        String type = mime.getExtensionFromMimeType(cR.getType(fileUri));
        ProgressRequestBody fileBody = new ProgressRequestBody(file, type, this);
        MultipartBody.Part fileData = MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)fileBody);
        HashMap<String, String> apiParams = new HashMap<String, String>();
        apiParams.put("api_signature", shaGenerator.getApiSignature());
        apiParams.put("api_key", APIConfiguration.apiKey);
        apiParams.put("api_nonce", shaGenerator.getApiNonce());
        apiParams.put("api_timestamp", shaGenerator.getApiTimeStamp());
        if (optionalParams != null) {
            for (Map.Entry<String, String> entry : optionalParams.entrySet()) {
                apiParams.put(entry.getKey(), entry.getValue());
            }
        }
        if (NetworkService.isNetworkAvailable(this.mContext)) {
            Call<JsonObject> call = apiService.callCreateFile(fileData, apiParams);
            call.enqueue((Callback)new Callback<JsonObject>(){

                public void onResponse(Call<JsonObject> call, Response<JsonObject> response) {
                    if (response.body() != null) {
                        callback.success(((JsonObject)response.body()).getAsJsonObject());
                    } else if (response.errorBody() != null) {
                        try {
                            callback.failure(response.errorBody().string());
                        }
                        catch (IOException e) {
                            callback.failure(e.getMessage());
                        }
                    }
                }

                public void onFailure(Call<JsonObject> call, Throwable t) {
                    LogUtils.LOGD(PublitioFiles.class.getSimpleName(), t.getMessage());
                    callback.failure(t.getMessage());
                }
            });
        } else {
            callback.failure(this.mContext.getString(R.string.no_network_found));
        }
    }

    @Override
    public void onProgressUpdate(int percentage) {
    }

    @Override
    public void onError() {
    }

    @Override
    public void onFinish() {
    }
}

