/*
 * Decompiled with CFR 0.152.
 */
package com.pszymczyk.consul;

import com.pszymczyk.consul.ConsulPorts;
import com.pszymczyk.consul.ConsulProcess;
import com.pszymczyk.consul.ConsulStarter;
import com.pszymczyk.consul.CustomConfig;
import com.pszymczyk.consul.LogLevel;
import com.pszymczyk.consul.Service;
import com.pszymczyk.consul.UserInput;
import com.pszymczyk.consul.infrastructure.StringUtils;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ArrayUtil;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.slf4j.Logger;

public class ConsulStarterBuilder
implements GroovyObject {
    private final Set<Service> services;
    private Path dataDir;
    private Path downloadDir;
    private Path configDir;
    private CustomConfig customConfig;
    private String consulVersion;
    private LogLevel logLevel;
    private Logger customLogger;
    private ConsulPorts.ConsulPortsBuilder consulPortsBuilder;
    private String startJoin;
    private String bind;
    private String advertise;
    private String client;
    private String token;
    private Integer waitTimeout;
    private boolean disableAddingShutdownHook;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    private ConsulStarterBuilder() {
        MetaClass metaClass;
        boolean bl;
        String string;
        String string2;
        String string3;
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[0].callConstructor(LinkedHashSet.class);
        this.services = (Set)ScriptBytecodeAdapter.castToType((Object)object, Set.class);
        Object object2 = callSiteArray[1].call(CustomConfig.class);
        this.customConfig = (CustomConfig)ScriptBytecodeAdapter.castToType((Object)object2, CustomConfig.class);
        this.consulVersion = string3 = "1.8.6";
        Object object3 = callSiteArray[2].callGetProperty(LogLevel.class);
        this.logLevel = (LogLevel)ShortTypeHandling.castToEnum((Object)object3, LogLevel.class);
        Object object4 = callSiteArray[3].call(ConsulPorts.class);
        this.consulPortsBuilder = (ConsulPorts.ConsulPortsBuilder)ScriptBytecodeAdapter.castToType((Object)object4, ConsulPorts.ConsulPortsBuilder.class);
        this.advertise = string2 = "127.0.0.1";
        this.client = string = "127.0.0.1";
        this.disableAddingShutdownHook = bl = false;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static ConsulStarterBuilder consulStarter() {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        return (ConsulStarterBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[4].callConstructor(ConsulStarterBuilder.class), ConsulStarterBuilder.class);
    }

    public ConsulStarterBuilder withLogLevel(LogLevel logLevel) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[5].callStatic(Objects.class, (Object)logLevel, (Object)"Given log level cannot be null.");
        this.logLevel = (LogLevel)ShortTypeHandling.castToEnum((Object)object, LogLevel.class);
        return this;
    }

    public ConsulStarterBuilder withLogger(Logger customLogger) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[6].callStatic(Objects.class, (Object)customLogger, (Object)"Given logger cannot be null.");
        this.customLogger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        return this;
    }

    public ConsulStarterBuilder withDataDirectory(Path dataDir) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[7].callStatic(Objects.class, (Object)dataDir, (Object)"Given data directory cannot be null.");
        this.dataDir = (Path)ScriptBytecodeAdapter.castToType((Object)object, Path.class);
        return this;
    }

    public ConsulStarterBuilder withConsulBinaryDownloadDirectory(Path downloadDir) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[8].callStatic(Objects.class, (Object)downloadDir, (Object)"Given download directory cannot be null.");
        this.downloadDir = (Path)ScriptBytecodeAdapter.castToType((Object)object, Path.class);
        return this;
    }

    public ConsulStarterBuilder withConsulVersion(String consulVersion) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[9].callStatic(StringUtils.class, (Object)consulVersion, (Object)"Given Consul version cannot be null or blank.");
        this.consulVersion = ShortTypeHandling.castToString((Object)object);
        return this;
    }

    public ConsulStarterBuilder withConfigDir(Path configDir) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[10].callStatic(Objects.class, (Object)configDir, (Object)"Given configuration directory cannot be null.");
        this.configDir = (Path)ScriptBytecodeAdapter.castToType((Object)object, Path.class);
        return this;
    }

    public ConsulStarterBuilder withCustomConfig(String customConfig) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[11].callConstructor(CustomConfig.class, callSiteArray[12].callStatic(StringUtils.class, (Object)customConfig, (Object)"Given custom configuration cannot bu null or blank."));
        this.customConfig = (CustomConfig)ScriptBytecodeAdapter.castToType((Object)object, CustomConfig.class);
        return this;
    }

    public ConsulStarterBuilder withHttpPort(int httpPort) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        callSiteArray[13].call((Object)this.consulPortsBuilder, (Object)httpPort);
        return this;
    }

    public ConsulStarterBuilder withConsulPorts(ConsulPorts consulPorts) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        callSiteArray[14].call((Object)this.consulPortsBuilder, callSiteArray[15].callStatic(Objects.class, (Object)consulPorts, (Object)"Given Consul ports cannot be null."));
        return this;
    }

    public ConsulStarterBuilder withAttachedTo(ConsulProcess otherProcess) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        callSiteArray[16].callStatic(Objects.class, (Object)otherProcess, (Object)"Given process to join cannot be null.");
        GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[17].callGroovyObjectGetProperty((Object)otherProcess), callSiteArray[18].callGroovyObjectGetProperty((Object)otherProcess)}, new String[]{"", ":", ""});
        this.startJoin = ShortTypeHandling.castToString((Object)gStringImpl);
        return this;
    }

    public ConsulStarterBuilder withAdvertise(String advertise) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[19].callStatic(StringUtils.class, (Object)advertise, (Object)"Given advertise address cannot be null or blank.");
        this.advertise = ShortTypeHandling.castToString((Object)object);
        return this;
    }

    public ConsulStarterBuilder withClient(String client) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[20].callStatic(StringUtils.class, (Object)client, (Object)"Given client cannot be null or blank.");
        this.client = ShortTypeHandling.castToString((Object)object);
        return this;
    }

    public ConsulStarterBuilder withBind(String bind) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[21].callStatic(StringUtils.class, (Object)bind, (Object)"Given bind address cannot be null or blank.");
        this.bind = ShortTypeHandling.castToString((Object)object);
        return this;
    }

    public ConsulStarterBuilder withToken(String token) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        Object object = callSiteArray[22].callStatic(StringUtils.class, (Object)token, (Object)"Given token cannot be null or blank");
        this.token = ShortTypeHandling.castToString((Object)object);
        return this;
    }

    public ConsulStarterBuilder withWaitTimeout(int timeoutSeconds) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        int n = timeoutSeconds;
        this.waitTimeout = n;
        return this;
    }

    public ConsulStarterBuilder disableAddingShutdownHook() {
        boolean bl;
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        this.disableAddingShutdownHook = bl = true;
        return this;
    }

    public ConsulStarterBuilder withService(Service ... serviceName) {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        callSiteArray[23].call(this.services, (Object)serviceName);
        return this;
    }

    public ConsulProcess buildAndStart() {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return (ConsulProcess)ScriptBytecodeAdapter.castToType((Object)callSiteArray[24].call(callSiteArray[25].callCurrent((GroovyObject)this)), ConsulProcess.class);
        }
        return (ConsulProcess)ScriptBytecodeAdapter.castToType((Object)callSiteArray[26].call((Object)this.build()), ConsulProcess.class);
    }

    public ConsulStarter build() {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[27].callCurrent((GroovyObject)this);
        } else {
            this.applyDefaults();
        }
        return (ConsulStarter)ScriptBytecodeAdapter.castToType((Object)callSiteArray[28].callConstructor(ConsulStarter.class, callSiteArray[29].callConstructor(UserInput.class, ArrayUtil.createArray((Object)this.dataDir, (Object)this.downloadDir, (Object)this.configDir, (Object)this.consulVersion, (Object)this.customConfig, (Object)((Object)this.logLevel), (Object)this.customLogger, (Object)this.consulPortsBuilder, (Object)this.startJoin, (Object)this.advertise, (Object)this.client, (Object)this.bind, (Object)this.token, (Object)this.waitTimeout, (Object)this.disableAddingShutdownHook, this.services))), ConsulStarter.class);
    }

    private void applyDefaults() {
        CallSite[] callSiteArray = ConsulStarterBuilder.$getCallSiteArray();
        if (ScriptBytecodeAdapter.compareEqual((Object)this.downloadDir, null)) {
            Object object = callSiteArray[30].call(Paths.class, callSiteArray[31].call(callSiteArray[32].callGetProperty(callSiteArray[33].call(Files.class, (Object)""))), (Object)new GStringImpl(new Object[]{this.consulVersion}, new String[]{"embedded-consul-", ""}));
            this.downloadDir = (Path)ScriptBytecodeAdapter.castToType((Object)object, Path.class);
            callSiteArray[34].call(Files.class, (Object)this.downloadDir);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.dataDir, null)) {
            Object object = callSiteArray[35].call(Files.class, (Object)"embedded-consul-data-dir");
            this.dataDir = (Path)ScriptBytecodeAdapter.castToType((Object)object, Path.class);
        }
        if (ScriptBytecodeAdapter.compareEqual((Object)this.configDir, null)) {
            Object object = callSiteArray[36].call(Files.class, (Object)"embedded-consul-config-dir");
            this.configDir = (Path)ScriptBytecodeAdapter.castToType((Object)object, Path.class);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ConsulStarterBuilder.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "<$constructor$>";
        stringArray[1] = "empty";
        stringArray[2] = "ERR";
        stringArray[3] = "consulPorts";
        stringArray[4] = "<$constructor$>";
        stringArray[5] = "requireNonNull";
        stringArray[6] = "requireNonNull";
        stringArray[7] = "requireNonNull";
        stringArray[8] = "requireNonNull";
        stringArray[9] = "requireNotBlank";
        stringArray[10] = "requireNonNull";
        stringArray[11] = "<$constructor$>";
        stringArray[12] = "requireNotBlank";
        stringArray[13] = "withHttpPort";
        stringArray[14] = "fromConsulPorts";
        stringArray[15] = "requireNonNull";
        stringArray[16] = "requireNonNull";
        stringArray[17] = "address";
        stringArray[18] = "serfLanPort";
        stringArray[19] = "requireNotBlank";
        stringArray[20] = "requireNotBlank";
        stringArray[21] = "requireNotBlank";
        stringArray[22] = "requireNotBlank";
        stringArray[23] = "addAll";
        stringArray[24] = "start";
        stringArray[25] = "build";
        stringArray[26] = "start";
        stringArray[27] = "applyDefaults";
        stringArray[28] = "<$constructor$>";
        stringArray[29] = "<$constructor$>";
        stringArray[30] = "get";
        stringArray[31] = "toString";
        stringArray[32] = "parent";
        stringArray[33] = "createTempDirectory";
        stringArray[34] = "createDirectories";
        stringArray[35] = "createTempDirectory";
        stringArray[36] = "createTempDirectory";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[37];
        ConsulStarterBuilder.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ConsulStarterBuilder.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ConsulStarterBuilder.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

