/*
 * Decompiled with CFR 0.152.
 */
package com.pswidersk.gradle.python;

import com.pswidersk.gradle.python.ProgressLogger;
import com.pswidersk.gradle.python.ProgressObserver;
import com.pswidersk.gradle.python.PythonPluginExtension;
import com.pswidersk.gradle.python.PythonPluginUtilsKt;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.input.ObservableInputStream;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.Directory;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\bH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/pswidersk/gradle/python/CondaDownloadTask;", "Lorg/gradle/api/DefaultTask;", "()V", "progressLogger", "Lcom/pswidersk/gradle/python/ProgressLogger;", "pythonPlugin", "Lcom/pswidersk/gradle/python/PythonPluginExtension;", "addBasicAuth", "", "connection", "Ljava/net/URLConnection;", "addCustomHeaders", "downloadConda", "destinationFile", "Ljava/io/File;", "getExecutable", "setup", "python-gradle-plugin"})
public abstract class CondaDownloadTask
extends DefaultTask {
    @NotNull
    private final PythonPluginExtension pythonPlugin;
    @NotNull
    private final ProgressLogger progressLogger;

    public CondaDownloadTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        this.pythonPlugin = PythonPluginUtilsKt.getPythonPlugin(project);
        this.progressLogger = new ProgressLogger((Function1)new Function1<String, Unit>(this){
            final /* synthetic */ CondaDownloadTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull String msg) {
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                this.this$0.getLogger().quiet(msg);
            }
        }, 0, 2, null);
        this.setGroup("python");
        this.setDescription("Download " + (String)this.pythonPlugin.getCondaInstaller().get());
        this.onlyIf(arg_0 -> CondaDownloadTask._init_$lambda-0(this, arg_0));
    }

    @TaskAction
    public final void setup() {
        PythonPluginExtension $this$setup_u24lambda_u2d1 = this.pythonPlugin;
        boolean bl = false;
        RegularFile condaInstaller = (RegularFile)$this$setup_u24lambda_u2d1.getCondaInstallerFile$python_gradle_plugin().get();
        File file = condaInstaller.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"condaInstaller.asFile");
        this.downloadConda(file);
    }

    private final void downloadConda(File destinationFile) {
        String string;
        block1: {
            Object object = this.pythonPlugin.getCondaRepoUrl().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pythonPlugin.condaRepoUrl.get()");
            String $this$dropLastWhile$iv = (String)object;
            boolean $i$f$dropLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$dropLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$dropLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == '/') continue;
                String string2 = $this$dropLastWhile$iv;
                int n = 0;
                int n2 = index$iv + 1;
                String string3 = string2.substring(n, n2);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block1;
            }
            string = "";
        }
        String condaRepoUrl = string;
        String condaInstaller = (String)this.pythonPlugin.getCondaInstaller().get();
        this.getLogger().lifecycle("Downloading " + condaInstaller + " to: " + destinationFile.getCanonicalPath() + " from: " + condaRepoUrl + " (please wait, it can take a while)");
        URLConnection connection = new URL(condaRepoUrl + '/' + destinationFile.getName()).openConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"connection");
        this.addBasicAuth(connection);
        this.addCustomHeaders(connection);
        this.getExecutable(connection, destinationFile);
    }

    private final void addBasicAuth(URLConnection connection) {
        if (this.pythonPlugin.getCondaRepoUsername().isPresent()) {
            String condaRepoUsername = (String)this.pythonPlugin.getCondaRepoUsername().get();
            String condaRepoPassword = (String)this.pythonPlugin.getCondaRepoPassword().get();
            this.getLogger().lifecycle("Adding basic authorization headers for '" + condaRepoUsername + "' user.");
            String userAndPass = condaRepoUsername + ':' + condaRepoPassword;
            StringBuilder stringBuilder = new StringBuilder().append("Basic ");
            Base64.Encoder encoder = Base64.getEncoder();
            String string = userAndPass;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = encoder.encode(byArray);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoder().encode(userAndPass.toByteArray())");
            byte[] byArray3 = byArray2;
            String basicAuth = stringBuilder.append(new String(byArray3, Charsets.UTF_8)).toString();
            connection.setRequestProperty("Authorization", basicAuth);
        }
    }

    private final void addCustomHeaders(URLConnection connection) {
        Map condaRepoHeaders = (Map)this.pythonPlugin.getCondaRepoHeaders().get();
        Intrinsics.checkNotNullExpressionValue((Object)condaRepoHeaders, (String)"condaRepoHeaders");
        Map $this$forEach$iv = condaRepoHeaders;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            connection.addRequestProperty((String)it.getKey(), (String)it.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void getExecutable(URLConnection connection, File destinationFile) {
        ProgressObserver progressObserver = new ProgressObserver(this.progressLogger, connection, 0, 4, null);
        ObservableInputStream.Observer[] observerArray = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)observerArray, (String)"connection.getInputStream()");
        Object object = observerArray;
        int n = 8192;
        BufferedInputStream bufferedInputStream = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
        object = new ObservableInputStream.Observer[]{progressObserver};
        ObservableInputStream urlInputStream = new ObservableInputStream((InputStream)bufferedInputStream, object);
        object = (Closeable)urlInputStream;
        Throwable throwable = null;
        try {
            long l;
            ObservableInputStream input = (ObservableInputStream)object;
            boolean bl = false;
            Closeable closeable = new FileOutputStream(destinationFile);
            Throwable throwable2 = null;
            try {
                FileOutputStream output = (FileOutputStream)closeable;
                boolean bl2 = false;
                l = ByteStreamsKt.copyTo$default((InputStream)((InputStream)input), (OutputStream)output, (int)0, (int)2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        destinationFile.setExecutable(true);
    }

    private static final boolean _init_$lambda-0(CondaDownloadTask this$0, Task it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        return !((Directory)this$0.pythonPlugin.getCondaBinDir$python_gradle_plugin().get()).getAsFile().exists();
    }
}

