/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.utils;

import com.prove.proveapi.utils.BackoffStrategy;
import com.prove.proveapi.utils.Utils;
import java.util.Optional;

public class RetryConfig {
    private final Strategy strategy;
    private final Optional<BackoffStrategy> backoff;

    private RetryConfig(Strategy strategy, Optional<BackoffStrategy> backoff) {
        this.strategy = strategy;
        this.backoff = backoff;
    }

    public static RetryConfig noRetries() {
        return RetryConfig.builder().noRetries().build();
    }

    public Strategy strategy() {
        return this.strategy;
    }

    public Optional<BackoffStrategy> backoff() {
        return this.backoff;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Strategy strategy = Strategy.NONE;
        private boolean enabled = true;
        private Optional<BackoffStrategy> backoff = Optional.empty();

        private Builder() {
        }

        public Builder noRetries() {
            this.strategy = Strategy.NONE;
            return this;
        }

        public Builder enable() {
            this.enabled = true;
            return this;
        }

        public Builder enable(boolean enable) {
            this.enabled = enable;
            return this;
        }

        public Builder backoff(BackoffStrategy backoff) {
            Utils.checkNotNull(backoff, "backoff");
            this.strategy = Strategy.BACKOFF;
            this.backoff = Optional.ofNullable(backoff);
            return this;
        }

        public Builder backoff() {
            this.strategy = Strategy.BACKOFF;
            this.backoff = Optional.ofNullable(BackoffStrategy.withDefaults());
            return this;
        }

        public RetryConfig build() {
            if (!this.enabled) {
                return RetryConfig.noRetries();
            }
            return new RetryConfig(this.strategy, this.backoff);
        }
    }

    public static enum Strategy {
        BACKOFF,
        NONE;

    }
}

