/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3VerifyResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class V3VerifyRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3VerifyResponse> v3VerifyResponse;

    @JsonCreator
    public V3VerifyRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3VerifyResponse> v3VerifyResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3VerifyResponse, "v3VerifyResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3VerifyResponse = v3VerifyResponse;
    }

    public V3VerifyRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3VerifyResponse> v3VerifyResponse() {
        return this.v3VerifyResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3VerifyRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3VerifyRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3VerifyRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3VerifyRequestResponse withV3VerifyResponse(V3VerifyResponse v3VerifyResponse) {
        Utils.checkNotNull(v3VerifyResponse, "v3VerifyResponse");
        this.v3VerifyResponse = Optional.ofNullable(v3VerifyResponse);
        return this;
    }

    public V3VerifyRequestResponse withV3VerifyResponse(Optional<? extends V3VerifyResponse> v3VerifyResponse) {
        Utils.checkNotNull(v3VerifyResponse, "v3VerifyResponse");
        this.v3VerifyResponse = v3VerifyResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3VerifyRequestResponse other = (V3VerifyRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3VerifyResponse, other.v3VerifyResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3VerifyResponse);
    }

    public String toString() {
        return Utils.toString(V3VerifyRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3VerifyResponse", this.v3VerifyResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3VerifyResponse> v3VerifyResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3VerifyResponse(V3VerifyResponse v3VerifyResponse) {
            Utils.checkNotNull(v3VerifyResponse, "v3VerifyResponse");
            this.v3VerifyResponse = Optional.ofNullable(v3VerifyResponse);
            return this;
        }

        public Builder v3VerifyResponse(Optional<? extends V3VerifyResponse> v3VerifyResponse) {
            Utils.checkNotNull(v3VerifyResponse, "v3VerifyResponse");
            this.v3VerifyResponse = v3VerifyResponse;
            return this;
        }

        public V3VerifyRequestResponse build() {
            return new V3VerifyRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3VerifyResponse);
        }
    }
}

