/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.operations;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.prove.proveapi.models.components.V3ValidateResponse;
import com.prove.proveapi.utils.Response;
import com.prove.proveapi.utils.Utils;
import java.io.InputStream;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.Optional;

public class V3ValidateRequestResponse
implements Response {
    private String contentType;
    private int statusCode;
    private HttpResponse<InputStream> rawResponse;
    private Optional<? extends V3ValidateResponse> v3ValidateResponse;

    @JsonCreator
    public V3ValidateRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse, Optional<? extends V3ValidateResponse> v3ValidateResponse) {
        Utils.checkNotNull(contentType, "contentType");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(rawResponse, "rawResponse");
        Utils.checkNotNull(v3ValidateResponse, "v3ValidateResponse");
        this.contentType = contentType;
        this.statusCode = statusCode;
        this.rawResponse = rawResponse;
        this.v3ValidateResponse = v3ValidateResponse;
    }

    public V3ValidateRequestResponse(String contentType, int statusCode, HttpResponse<InputStream> rawResponse) {
        this(contentType, statusCode, rawResponse, Optional.empty());
    }

    @Override
    @JsonIgnore
    public String contentType() {
        return this.contentType;
    }

    @Override
    @JsonIgnore
    public int statusCode() {
        return this.statusCode;
    }

    @Override
    @JsonIgnore
    public HttpResponse<InputStream> rawResponse() {
        return this.rawResponse;
    }

    @JsonIgnore
    public Optional<V3ValidateResponse> v3ValidateResponse() {
        return this.v3ValidateResponse;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3ValidateRequestResponse withContentType(String contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    public V3ValidateRequestResponse withStatusCode(int statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    public V3ValidateRequestResponse withRawResponse(HttpResponse<InputStream> rawResponse) {
        Utils.checkNotNull(rawResponse, "rawResponse");
        this.rawResponse = rawResponse;
        return this;
    }

    public V3ValidateRequestResponse withV3ValidateResponse(V3ValidateResponse v3ValidateResponse) {
        Utils.checkNotNull(v3ValidateResponse, "v3ValidateResponse");
        this.v3ValidateResponse = Optional.ofNullable(v3ValidateResponse);
        return this;
    }

    public V3ValidateRequestResponse withV3ValidateResponse(Optional<? extends V3ValidateResponse> v3ValidateResponse) {
        Utils.checkNotNull(v3ValidateResponse, "v3ValidateResponse");
        this.v3ValidateResponse = v3ValidateResponse;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3ValidateRequestResponse other = (V3ValidateRequestResponse)o;
        return Objects.deepEquals(this.contentType, other.contentType) && Objects.deepEquals(this.statusCode, other.statusCode) && Objects.deepEquals(this.rawResponse, other.rawResponse) && Objects.deepEquals(this.v3ValidateResponse, other.v3ValidateResponse);
    }

    public int hashCode() {
        return Objects.hash(this.contentType, this.statusCode, this.rawResponse, this.v3ValidateResponse);
    }

    public String toString() {
        return Utils.toString(V3ValidateRequestResponse.class, "contentType", this.contentType, "statusCode", this.statusCode, "rawResponse", this.rawResponse, "v3ValidateResponse", this.v3ValidateResponse);
    }

    public static final class Builder {
        private String contentType;
        private Integer statusCode;
        private HttpResponse<InputStream> rawResponse;
        private Optional<? extends V3ValidateResponse> v3ValidateResponse = Optional.empty();

        private Builder() {
        }

        public Builder contentType(String contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Builder statusCode(int statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }

        public Builder rawResponse(HttpResponse<InputStream> rawResponse) {
            Utils.checkNotNull(rawResponse, "rawResponse");
            this.rawResponse = rawResponse;
            return this;
        }

        public Builder v3ValidateResponse(V3ValidateResponse v3ValidateResponse) {
            Utils.checkNotNull(v3ValidateResponse, "v3ValidateResponse");
            this.v3ValidateResponse = Optional.ofNullable(v3ValidateResponse);
            return this;
        }

        public Builder v3ValidateResponse(Optional<? extends V3ValidateResponse> v3ValidateResponse) {
            Utils.checkNotNull(v3ValidateResponse, "v3ValidateResponse");
            this.v3ValidateResponse = v3ValidateResponse;
            return this;
        }

        public V3ValidateRequestResponse build() {
            return new V3ValidateRequestResponse(this.contentType, this.statusCode, this.rawResponse, this.v3ValidateResponse);
        }
    }
}

