/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class V3VerifyResponse {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="authToken")
    private Optional<String> authToken;
    @JsonProperty(value="correlationId")
    private String correlationId;
    @JsonProperty(value="possessionResult")
    private String possessionResult;
    @JsonProperty(value="success")
    private String success;
    @JsonProperty(value="verifyResult")
    private String verifyResult;

    @JsonCreator
    public V3VerifyResponse(@JsonProperty(value="authToken") Optional<String> authToken, @JsonProperty(value="correlationId") String correlationId, @JsonProperty(value="possessionResult") String possessionResult, @JsonProperty(value="success") String success, @JsonProperty(value="verifyResult") String verifyResult) {
        Utils.checkNotNull(authToken, "authToken");
        Utils.checkNotNull(correlationId, "correlationId");
        Utils.checkNotNull(possessionResult, "possessionResult");
        Utils.checkNotNull(success, "success");
        Utils.checkNotNull(verifyResult, "verifyResult");
        this.authToken = authToken;
        this.correlationId = correlationId;
        this.possessionResult = possessionResult;
        this.success = success;
        this.verifyResult = verifyResult;
    }

    public V3VerifyResponse(String correlationId, String possessionResult, String success, String verifyResult) {
        this(Optional.empty(), correlationId, possessionResult, success, verifyResult);
    }

    @JsonIgnore
    public Optional<String> authToken() {
        return this.authToken;
    }

    @JsonIgnore
    public String correlationId() {
        return this.correlationId;
    }

    @JsonIgnore
    public String possessionResult() {
        return this.possessionResult;
    }

    @JsonIgnore
    public String success() {
        return this.success;
    }

    @JsonIgnore
    public String verifyResult() {
        return this.verifyResult;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3VerifyResponse withAuthToken(String authToken) {
        Utils.checkNotNull(authToken, "authToken");
        this.authToken = Optional.ofNullable(authToken);
        return this;
    }

    public V3VerifyResponse withAuthToken(Optional<String> authToken) {
        Utils.checkNotNull(authToken, "authToken");
        this.authToken = authToken;
        return this;
    }

    public V3VerifyResponse withCorrelationId(String correlationId) {
        Utils.checkNotNull(correlationId, "correlationId");
        this.correlationId = correlationId;
        return this;
    }

    public V3VerifyResponse withPossessionResult(String possessionResult) {
        Utils.checkNotNull(possessionResult, "possessionResult");
        this.possessionResult = possessionResult;
        return this;
    }

    public V3VerifyResponse withSuccess(String success) {
        Utils.checkNotNull(success, "success");
        this.success = success;
        return this;
    }

    public V3VerifyResponse withVerifyResult(String verifyResult) {
        Utils.checkNotNull(verifyResult, "verifyResult");
        this.verifyResult = verifyResult;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3VerifyResponse other = (V3VerifyResponse)o;
        return Objects.deepEquals(this.authToken, other.authToken) && Objects.deepEquals(this.correlationId, other.correlationId) && Objects.deepEquals(this.possessionResult, other.possessionResult) && Objects.deepEquals(this.success, other.success) && Objects.deepEquals(this.verifyResult, other.verifyResult);
    }

    public int hashCode() {
        return Objects.hash(this.authToken, this.correlationId, this.possessionResult, this.success, this.verifyResult);
    }

    public String toString() {
        return Utils.toString(V3VerifyResponse.class, "authToken", this.authToken, "correlationId", this.correlationId, "possessionResult", this.possessionResult, "success", this.success, "verifyResult", this.verifyResult);
    }

    public static final class Builder {
        private Optional<String> authToken = Optional.empty();
        private String correlationId;
        private String possessionResult;
        private String success;
        private String verifyResult;

        private Builder() {
        }

        public Builder authToken(String authToken) {
            Utils.checkNotNull(authToken, "authToken");
            this.authToken = Optional.ofNullable(authToken);
            return this;
        }

        public Builder authToken(Optional<String> authToken) {
            Utils.checkNotNull(authToken, "authToken");
            this.authToken = authToken;
            return this;
        }

        public Builder correlationId(String correlationId) {
            Utils.checkNotNull(correlationId, "correlationId");
            this.correlationId = correlationId;
            return this;
        }

        public Builder possessionResult(String possessionResult) {
            Utils.checkNotNull(possessionResult, "possessionResult");
            this.possessionResult = possessionResult;
            return this;
        }

        public Builder success(String success) {
            Utils.checkNotNull(success, "success");
            this.success = success;
            return this;
        }

        public Builder verifyResult(String verifyResult) {
            Utils.checkNotNull(verifyResult, "verifyResult");
            this.verifyResult = verifyResult;
            return this;
        }

        public V3VerifyResponse build() {
            return new V3VerifyResponse(this.authToken, this.correlationId, this.possessionResult, this.success, this.verifyResult);
        }
    }
}

