/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Map;
import java.util.Objects;

public class V3StartResponse {
    @JsonProperty(value="authToken")
    private String authToken;
    @JsonProperty(value="correlationId")
    private String correlationId;
    @JsonProperty(value="next")
    private Map<String, String> next;

    @JsonCreator
    public V3StartResponse(@JsonProperty(value="authToken") String authToken, @JsonProperty(value="correlationId") String correlationId, @JsonProperty(value="next") Map<String, String> next) {
        Utils.checkNotNull(authToken, "authToken");
        Utils.checkNotNull(correlationId, "correlationId");
        next = Utils.emptyMapIfNull(next);
        this.authToken = authToken;
        this.correlationId = correlationId;
        this.next = next;
    }

    @JsonIgnore
    public String authToken() {
        return this.authToken;
    }

    @JsonIgnore
    public String correlationId() {
        return this.correlationId;
    }

    @JsonIgnore
    public Map<String, String> next() {
        return this.next;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3StartResponse withAuthToken(String authToken) {
        Utils.checkNotNull(authToken, "authToken");
        this.authToken = authToken;
        return this;
    }

    public V3StartResponse withCorrelationId(String correlationId) {
        Utils.checkNotNull(correlationId, "correlationId");
        this.correlationId = correlationId;
        return this;
    }

    public V3StartResponse withNext(Map<String, String> next) {
        Utils.checkNotNull(next, "next");
        this.next = next;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3StartResponse other = (V3StartResponse)o;
        return Objects.deepEquals(this.authToken, other.authToken) && Objects.deepEquals(this.correlationId, other.correlationId) && Objects.deepEquals(this.next, other.next);
    }

    public int hashCode() {
        return Objects.hash(this.authToken, this.correlationId, this.next);
    }

    public String toString() {
        return Utils.toString(V3StartResponse.class, "authToken", this.authToken, "correlationId", this.correlationId, "next", this.next);
    }

    public static final class Builder {
        private String authToken;
        private String correlationId;
        private Map<String, String> next;

        private Builder() {
        }

        public Builder authToken(String authToken) {
            Utils.checkNotNull(authToken, "authToken");
            this.authToken = authToken;
            return this;
        }

        public Builder correlationId(String correlationId) {
            Utils.checkNotNull(correlationId, "correlationId");
            this.correlationId = correlationId;
            return this;
        }

        public Builder next(Map<String, String> next) {
            Utils.checkNotNull(next, "next");
            this.next = next;
            return this;
        }

        public V3StartResponse build() {
            return new V3StartResponse(this.authToken, this.correlationId, this.next);
        }
    }
}

