/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.models.components.V3ChallengeAddressEntryRequest;
import com.prove.proveapi.utils.Utils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class V3ChallengeIndividualRequest {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="addresses")
    private Optional<? extends List<V3ChallengeAddressEntryRequest>> addresses;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="dob")
    private Optional<String> dob;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="emailAddresses")
    private Optional<? extends List<String>> emailAddresses;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="firstName")
    private Optional<String> firstName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="lastName")
    private Optional<String> lastName;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="ssn")
    private Optional<String> ssn;

    @JsonCreator
    public V3ChallengeIndividualRequest(@JsonProperty(value="addresses") Optional<? extends List<V3ChallengeAddressEntryRequest>> addresses, @JsonProperty(value="dob") Optional<String> dob, @JsonProperty(value="emailAddresses") Optional<? extends List<String>> emailAddresses, @JsonProperty(value="firstName") Optional<String> firstName, @JsonProperty(value="lastName") Optional<String> lastName, @JsonProperty(value="ssn") Optional<String> ssn) {
        Utils.checkNotNull(addresses, "addresses");
        Utils.checkNotNull(dob, "dob");
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        Utils.checkNotNull(firstName, "firstName");
        Utils.checkNotNull(lastName, "lastName");
        Utils.checkNotNull(ssn, "ssn");
        this.addresses = addresses;
        this.dob = dob;
        this.emailAddresses = emailAddresses;
        this.firstName = firstName;
        this.lastName = lastName;
        this.ssn = ssn;
    }

    public V3ChallengeIndividualRequest() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<List<V3ChallengeAddressEntryRequest>> addresses() {
        return this.addresses;
    }

    @JsonIgnore
    public Optional<String> dob() {
        return this.dob;
    }

    @JsonIgnore
    public Optional<List<String>> emailAddresses() {
        return this.emailAddresses;
    }

    @JsonIgnore
    public Optional<String> firstName() {
        return this.firstName;
    }

    @JsonIgnore
    public Optional<String> lastName() {
        return this.lastName;
    }

    @JsonIgnore
    public Optional<String> ssn() {
        return this.ssn;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public V3ChallengeIndividualRequest withAddresses(List<V3ChallengeAddressEntryRequest> addresses) {
        Utils.checkNotNull(addresses, "addresses");
        this.addresses = Optional.ofNullable(addresses);
        return this;
    }

    public V3ChallengeIndividualRequest withAddresses(Optional<? extends List<V3ChallengeAddressEntryRequest>> addresses) {
        Utils.checkNotNull(addresses, "addresses");
        this.addresses = addresses;
        return this;
    }

    public V3ChallengeIndividualRequest withDob(String dob) {
        Utils.checkNotNull(dob, "dob");
        this.dob = Optional.ofNullable(dob);
        return this;
    }

    public V3ChallengeIndividualRequest withDob(Optional<String> dob) {
        Utils.checkNotNull(dob, "dob");
        this.dob = dob;
        return this;
    }

    public V3ChallengeIndividualRequest withEmailAddresses(List<String> emailAddresses) {
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        this.emailAddresses = Optional.ofNullable(emailAddresses);
        return this;
    }

    public V3ChallengeIndividualRequest withEmailAddresses(Optional<? extends List<String>> emailAddresses) {
        Utils.checkNotNull(emailAddresses, "emailAddresses");
        this.emailAddresses = emailAddresses;
        return this;
    }

    public V3ChallengeIndividualRequest withFirstName(String firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = Optional.ofNullable(firstName);
        return this;
    }

    public V3ChallengeIndividualRequest withFirstName(Optional<String> firstName) {
        Utils.checkNotNull(firstName, "firstName");
        this.firstName = firstName;
        return this;
    }

    public V3ChallengeIndividualRequest withLastName(String lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = Optional.ofNullable(lastName);
        return this;
    }

    public V3ChallengeIndividualRequest withLastName(Optional<String> lastName) {
        Utils.checkNotNull(lastName, "lastName");
        this.lastName = lastName;
        return this;
    }

    public V3ChallengeIndividualRequest withSsn(String ssn) {
        Utils.checkNotNull(ssn, "ssn");
        this.ssn = Optional.ofNullable(ssn);
        return this;
    }

    public V3ChallengeIndividualRequest withSsn(Optional<String> ssn) {
        Utils.checkNotNull(ssn, "ssn");
        this.ssn = ssn;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V3ChallengeIndividualRequest other = (V3ChallengeIndividualRequest)o;
        return Objects.deepEquals(this.addresses, other.addresses) && Objects.deepEquals(this.dob, other.dob) && Objects.deepEquals(this.emailAddresses, other.emailAddresses) && Objects.deepEquals(this.firstName, other.firstName) && Objects.deepEquals(this.lastName, other.lastName) && Objects.deepEquals(this.ssn, other.ssn);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.dob, this.emailAddresses, this.firstName, this.lastName, this.ssn);
    }

    public String toString() {
        return Utils.toString(V3ChallengeIndividualRequest.class, "addresses", this.addresses, "dob", this.dob, "emailAddresses", this.emailAddresses, "firstName", this.firstName, "lastName", this.lastName, "ssn", this.ssn);
    }

    public static final class Builder {
        private Optional<? extends List<V3ChallengeAddressEntryRequest>> addresses = Optional.empty();
        private Optional<String> dob = Optional.empty();
        private Optional<? extends List<String>> emailAddresses = Optional.empty();
        private Optional<String> firstName = Optional.empty();
        private Optional<String> lastName = Optional.empty();
        private Optional<String> ssn = Optional.empty();

        private Builder() {
        }

        public Builder addresses(List<V3ChallengeAddressEntryRequest> addresses) {
            Utils.checkNotNull(addresses, "addresses");
            this.addresses = Optional.ofNullable(addresses);
            return this;
        }

        public Builder addresses(Optional<? extends List<V3ChallengeAddressEntryRequest>> addresses) {
            Utils.checkNotNull(addresses, "addresses");
            this.addresses = addresses;
            return this;
        }

        public Builder dob(String dob) {
            Utils.checkNotNull(dob, "dob");
            this.dob = Optional.ofNullable(dob);
            return this;
        }

        public Builder dob(Optional<String> dob) {
            Utils.checkNotNull(dob, "dob");
            this.dob = dob;
            return this;
        }

        public Builder emailAddresses(List<String> emailAddresses) {
            Utils.checkNotNull(emailAddresses, "emailAddresses");
            this.emailAddresses = Optional.ofNullable(emailAddresses);
            return this;
        }

        public Builder emailAddresses(Optional<? extends List<String>> emailAddresses) {
            Utils.checkNotNull(emailAddresses, "emailAddresses");
            this.emailAddresses = emailAddresses;
            return this;
        }

        public Builder firstName(String firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = Optional.ofNullable(firstName);
            return this;
        }

        public Builder firstName(Optional<String> firstName) {
            Utils.checkNotNull(firstName, "firstName");
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = Optional.ofNullable(lastName);
            return this;
        }

        public Builder lastName(Optional<String> lastName) {
            Utils.checkNotNull(lastName, "lastName");
            this.lastName = lastName;
            return this;
        }

        public Builder ssn(String ssn) {
            Utils.checkNotNull(ssn, "ssn");
            this.ssn = Optional.ofNullable(ssn);
            return this;
        }

        public Builder ssn(Optional<String> ssn) {
            Utils.checkNotNull(ssn, "ssn");
            this.ssn = ssn;
            return this;
        }

        public V3ChallengeIndividualRequest build() {
            return new V3ChallengeIndividualRequest(this.addresses, this.dob, this.emailAddresses, this.firstName, this.lastName, this.ssn);
        }
    }
}

