/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.models.components.DataSourceInternal;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class IDVDataInternal {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="dataSource1")
    private Optional<? extends DataSourceInternal> dataSource1;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="dataSource2")
    private Optional<? extends DataSourceInternal> dataSource2;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="multiCIPConfidence")
    private Optional<String> multiCIPConfidence;

    @JsonCreator
    public IDVDataInternal(@JsonProperty(value="dataSource1") Optional<? extends DataSourceInternal> dataSource1, @JsonProperty(value="dataSource2") Optional<? extends DataSourceInternal> dataSource2, @JsonProperty(value="multiCIPConfidence") Optional<String> multiCIPConfidence) {
        Utils.checkNotNull(dataSource1, "dataSource1");
        Utils.checkNotNull(dataSource2, "dataSource2");
        Utils.checkNotNull(multiCIPConfidence, "multiCIPConfidence");
        this.dataSource1 = dataSource1;
        this.dataSource2 = dataSource2;
        this.multiCIPConfidence = multiCIPConfidence;
    }

    public IDVDataInternal() {
        this(Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<DataSourceInternal> dataSource1() {
        return this.dataSource1;
    }

    @JsonIgnore
    public Optional<DataSourceInternal> dataSource2() {
        return this.dataSource2;
    }

    @JsonIgnore
    public Optional<String> multiCIPConfidence() {
        return this.multiCIPConfidence;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public IDVDataInternal withDataSource1(DataSourceInternal dataSource1) {
        Utils.checkNotNull(dataSource1, "dataSource1");
        this.dataSource1 = Optional.ofNullable(dataSource1);
        return this;
    }

    public IDVDataInternal withDataSource1(Optional<? extends DataSourceInternal> dataSource1) {
        Utils.checkNotNull(dataSource1, "dataSource1");
        this.dataSource1 = dataSource1;
        return this;
    }

    public IDVDataInternal withDataSource2(DataSourceInternal dataSource2) {
        Utils.checkNotNull(dataSource2, "dataSource2");
        this.dataSource2 = Optional.ofNullable(dataSource2);
        return this;
    }

    public IDVDataInternal withDataSource2(Optional<? extends DataSourceInternal> dataSource2) {
        Utils.checkNotNull(dataSource2, "dataSource2");
        this.dataSource2 = dataSource2;
        return this;
    }

    public IDVDataInternal withMultiCIPConfidence(String multiCIPConfidence) {
        Utils.checkNotNull(multiCIPConfidence, "multiCIPConfidence");
        this.multiCIPConfidence = Optional.ofNullable(multiCIPConfidence);
        return this;
    }

    public IDVDataInternal withMultiCIPConfidence(Optional<String> multiCIPConfidence) {
        Utils.checkNotNull(multiCIPConfidence, "multiCIPConfidence");
        this.multiCIPConfidence = multiCIPConfidence;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IDVDataInternal other = (IDVDataInternal)o;
        return Objects.deepEquals(this.dataSource1, other.dataSource1) && Objects.deepEquals(this.dataSource2, other.dataSource2) && Objects.deepEquals(this.multiCIPConfidence, other.multiCIPConfidence);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource1, this.dataSource2, this.multiCIPConfidence);
    }

    public String toString() {
        return Utils.toString(IDVDataInternal.class, "dataSource1", this.dataSource1, "dataSource2", this.dataSource2, "multiCIPConfidence", this.multiCIPConfidence);
    }

    public static final class Builder {
        private Optional<? extends DataSourceInternal> dataSource1 = Optional.empty();
        private Optional<? extends DataSourceInternal> dataSource2 = Optional.empty();
        private Optional<String> multiCIPConfidence = Optional.empty();

        private Builder() {
        }

        public Builder dataSource1(DataSourceInternal dataSource1) {
            Utils.checkNotNull(dataSource1, "dataSource1");
            this.dataSource1 = Optional.ofNullable(dataSource1);
            return this;
        }

        public Builder dataSource1(Optional<? extends DataSourceInternal> dataSource1) {
            Utils.checkNotNull(dataSource1, "dataSource1");
            this.dataSource1 = dataSource1;
            return this;
        }

        public Builder dataSource2(DataSourceInternal dataSource2) {
            Utils.checkNotNull(dataSource2, "dataSource2");
            this.dataSource2 = Optional.ofNullable(dataSource2);
            return this;
        }

        public Builder dataSource2(Optional<? extends DataSourceInternal> dataSource2) {
            Utils.checkNotNull(dataSource2, "dataSource2");
            this.dataSource2 = dataSource2;
            return this;
        }

        public Builder multiCIPConfidence(String multiCIPConfidence) {
            Utils.checkNotNull(multiCIPConfidence, "multiCIPConfidence");
            this.multiCIPConfidence = Optional.ofNullable(multiCIPConfidence);
            return this;
        }

        public Builder multiCIPConfidence(Optional<String> multiCIPConfidence) {
            Utils.checkNotNull(multiCIPConfidence, "multiCIPConfidence");
            this.multiCIPConfidence = multiCIPConfidence;
            return this;
        }

        public IDVDataInternal build() {
            return new IDVDataInternal(this.dataSource1, this.dataSource2, this.multiCIPConfidence);
        }
    }
}

