/*
 * Decompiled with CFR 0.152.
 */
package com.prove.proveapi.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.prove.proveapi.utils.Utils;
import java.util.Objects;
import java.util.Optional;

public class DataSourceAddressResponseInternal {
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="addressScore")
    private Optional<Long> addressScore;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="city")
    private Optional<Boolean> city;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="distance")
    private Optional<Double> distance;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="postalCode")
    private Optional<Boolean> postalCode;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="region")
    private Optional<Boolean> region;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="street")
    private Optional<Boolean> street;
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="streetNumber")
    private Optional<Long> streetNumber;

    @JsonCreator
    public DataSourceAddressResponseInternal(@JsonProperty(value="addressScore") Optional<Long> addressScore, @JsonProperty(value="city") Optional<Boolean> city, @JsonProperty(value="distance") Optional<Double> distance, @JsonProperty(value="postalCode") Optional<Boolean> postalCode, @JsonProperty(value="region") Optional<Boolean> region, @JsonProperty(value="street") Optional<Boolean> street, @JsonProperty(value="streetNumber") Optional<Long> streetNumber) {
        Utils.checkNotNull(addressScore, "addressScore");
        Utils.checkNotNull(city, "city");
        Utils.checkNotNull(distance, "distance");
        Utils.checkNotNull(postalCode, "postalCode");
        Utils.checkNotNull(region, "region");
        Utils.checkNotNull(street, "street");
        Utils.checkNotNull(streetNumber, "streetNumber");
        this.addressScore = addressScore;
        this.city = city;
        this.distance = distance;
        this.postalCode = postalCode;
        this.region = region;
        this.street = street;
        this.streetNumber = streetNumber;
    }

    public DataSourceAddressResponseInternal() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @JsonIgnore
    public Optional<Long> addressScore() {
        return this.addressScore;
    }

    @JsonIgnore
    public Optional<Boolean> city() {
        return this.city;
    }

    @JsonIgnore
    public Optional<Double> distance() {
        return this.distance;
    }

    @JsonIgnore
    public Optional<Boolean> postalCode() {
        return this.postalCode;
    }

    @JsonIgnore
    public Optional<Boolean> region() {
        return this.region;
    }

    @JsonIgnore
    public Optional<Boolean> street() {
        return this.street;
    }

    @JsonIgnore
    public Optional<Long> streetNumber() {
        return this.streetNumber;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public DataSourceAddressResponseInternal withAddressScore(long addressScore) {
        Utils.checkNotNull(addressScore, "addressScore");
        this.addressScore = Optional.ofNullable(addressScore);
        return this;
    }

    public DataSourceAddressResponseInternal withAddressScore(Optional<Long> addressScore) {
        Utils.checkNotNull(addressScore, "addressScore");
        this.addressScore = addressScore;
        return this;
    }

    public DataSourceAddressResponseInternal withCity(boolean city) {
        Utils.checkNotNull(city, "city");
        this.city = Optional.ofNullable(city);
        return this;
    }

    public DataSourceAddressResponseInternal withCity(Optional<Boolean> city) {
        Utils.checkNotNull(city, "city");
        this.city = city;
        return this;
    }

    public DataSourceAddressResponseInternal withDistance(double distance) {
        Utils.checkNotNull(distance, "distance");
        this.distance = Optional.ofNullable(distance);
        return this;
    }

    public DataSourceAddressResponseInternal withDistance(Optional<Double> distance) {
        Utils.checkNotNull(distance, "distance");
        this.distance = distance;
        return this;
    }

    public DataSourceAddressResponseInternal withPostalCode(boolean postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = Optional.ofNullable(postalCode);
        return this;
    }

    public DataSourceAddressResponseInternal withPostalCode(Optional<Boolean> postalCode) {
        Utils.checkNotNull(postalCode, "postalCode");
        this.postalCode = postalCode;
        return this;
    }

    public DataSourceAddressResponseInternal withRegion(boolean region) {
        Utils.checkNotNull(region, "region");
        this.region = Optional.ofNullable(region);
        return this;
    }

    public DataSourceAddressResponseInternal withRegion(Optional<Boolean> region) {
        Utils.checkNotNull(region, "region");
        this.region = region;
        return this;
    }

    public DataSourceAddressResponseInternal withStreet(boolean street) {
        Utils.checkNotNull(street, "street");
        this.street = Optional.ofNullable(street);
        return this;
    }

    public DataSourceAddressResponseInternal withStreet(Optional<Boolean> street) {
        Utils.checkNotNull(street, "street");
        this.street = street;
        return this;
    }

    public DataSourceAddressResponseInternal withStreetNumber(long streetNumber) {
        Utils.checkNotNull(streetNumber, "streetNumber");
        this.streetNumber = Optional.ofNullable(streetNumber);
        return this;
    }

    public DataSourceAddressResponseInternal withStreetNumber(Optional<Long> streetNumber) {
        Utils.checkNotNull(streetNumber, "streetNumber");
        this.streetNumber = streetNumber;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataSourceAddressResponseInternal other = (DataSourceAddressResponseInternal)o;
        return Objects.deepEquals(this.addressScore, other.addressScore) && Objects.deepEquals(this.city, other.city) && Objects.deepEquals(this.distance, other.distance) && Objects.deepEquals(this.postalCode, other.postalCode) && Objects.deepEquals(this.region, other.region) && Objects.deepEquals(this.street, other.street) && Objects.deepEquals(this.streetNumber, other.streetNumber);
    }

    public int hashCode() {
        return Objects.hash(this.addressScore, this.city, this.distance, this.postalCode, this.region, this.street, this.streetNumber);
    }

    public String toString() {
        return Utils.toString(DataSourceAddressResponseInternal.class, "addressScore", this.addressScore, "city", this.city, "distance", this.distance, "postalCode", this.postalCode, "region", this.region, "street", this.street, "streetNumber", this.streetNumber);
    }

    public static final class Builder {
        private Optional<Long> addressScore = Optional.empty();
        private Optional<Boolean> city = Optional.empty();
        private Optional<Double> distance = Optional.empty();
        private Optional<Boolean> postalCode = Optional.empty();
        private Optional<Boolean> region = Optional.empty();
        private Optional<Boolean> street = Optional.empty();
        private Optional<Long> streetNumber = Optional.empty();

        private Builder() {
        }

        public Builder addressScore(long addressScore) {
            Utils.checkNotNull(addressScore, "addressScore");
            this.addressScore = Optional.ofNullable(addressScore);
            return this;
        }

        public Builder addressScore(Optional<Long> addressScore) {
            Utils.checkNotNull(addressScore, "addressScore");
            this.addressScore = addressScore;
            return this;
        }

        public Builder city(boolean city) {
            Utils.checkNotNull(city, "city");
            this.city = Optional.ofNullable(city);
            return this;
        }

        public Builder city(Optional<Boolean> city) {
            Utils.checkNotNull(city, "city");
            this.city = city;
            return this;
        }

        public Builder distance(double distance) {
            Utils.checkNotNull(distance, "distance");
            this.distance = Optional.ofNullable(distance);
            return this;
        }

        public Builder distance(Optional<Double> distance) {
            Utils.checkNotNull(distance, "distance");
            this.distance = distance;
            return this;
        }

        public Builder postalCode(boolean postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = Optional.ofNullable(postalCode);
            return this;
        }

        public Builder postalCode(Optional<Boolean> postalCode) {
            Utils.checkNotNull(postalCode, "postalCode");
            this.postalCode = postalCode;
            return this;
        }

        public Builder region(boolean region) {
            Utils.checkNotNull(region, "region");
            this.region = Optional.ofNullable(region);
            return this;
        }

        public Builder region(Optional<Boolean> region) {
            Utils.checkNotNull(region, "region");
            this.region = region;
            return this;
        }

        public Builder street(boolean street) {
            Utils.checkNotNull(street, "street");
            this.street = Optional.ofNullable(street);
            return this;
        }

        public Builder street(Optional<Boolean> street) {
            Utils.checkNotNull(street, "street");
            this.street = street;
            return this;
        }

        public Builder streetNumber(long streetNumber) {
            Utils.checkNotNull(streetNumber, "streetNumber");
            this.streetNumber = Optional.ofNullable(streetNumber);
            return this;
        }

        public Builder streetNumber(Optional<Long> streetNumber) {
            Utils.checkNotNull(streetNumber, "streetNumber");
            this.streetNumber = streetNumber;
            return this;
        }

        public DataSourceAddressResponseInternal build() {
            return new DataSourceAddressResponseInternal(this.addressScore, this.city, this.distance, this.postalCode, this.region, this.street, this.streetNumber);
        }
    }
}

