/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.connect;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.proton.bluetooth.Constants;
import com.proton.bluetooth.RuntimeChecker;
import com.proton.bluetooth.connect.IBleConnectWorker;
import com.proton.bluetooth.connect.listener.GattResponseListener;
import com.proton.bluetooth.connect.listener.IBluetoothGattResponse;
import com.proton.bluetooth.connect.listener.ReadCharacterListener;
import com.proton.bluetooth.connect.listener.ReadDescriptorListener;
import com.proton.bluetooth.connect.listener.ReadRssiListener;
import com.proton.bluetooth.connect.listener.RequestMtuListener;
import com.proton.bluetooth.connect.listener.ServiceDiscoverListener;
import com.proton.bluetooth.connect.listener.WriteCharacterListener;
import com.proton.bluetooth.connect.listener.WriteDescriptorListener;
import com.proton.bluetooth.connect.response.BluetoothGattResponse;
import com.proton.bluetooth.model.BleGattProfile;
import com.proton.bluetooth.utils.ByteUtils;
import com.proton.bluetooth.utils.Logger;
import com.proton.bluetooth.utils.Utils;
import com.proton.bluetooth.utils.Version;
import com.proton.bluetooth.utils.proxy.ProxyBulk;
import com.proton.bluetooth.utils.proxy.ProxyInterceptor;
import com.proton.bluetooth.utils.proxy.ProxyUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class BleConnectWorker
implements Handler.Callback,
IBleConnectWorker,
IBluetoothGattResponse,
ProxyInterceptor,
RuntimeChecker {
    private static final int MSG_GATT_RESPONSE = 288;
    private BluetoothGatt mBluetoothGatt;
    private BluetoothDevice mBluetoothDevice;
    private GattResponseListener mGattResponseListener;
    private Handler mWorkerHandler;
    private volatile int mConnectStatus;
    private BleGattProfile mBleGattProfile;
    private Map<UUID, Map<UUID, BluetoothGattCharacteristic>> mDeviceProfile;
    private IBluetoothGattResponse mBluetoothGattResponse;
    private RuntimeChecker mRuntimeChecker;

    public BleConnectWorker(String mac, RuntimeChecker runtimeChecker) {
        BluetoothAdapter adapter = Utils.getBluetoothAdapter();
        if (adapter == null) {
            throw new IllegalStateException("ble adapter null");
        }
        this.mBluetoothDevice = adapter.getRemoteDevice(mac);
        this.mRuntimeChecker = runtimeChecker;
        this.mWorkerHandler = new Handler(Looper.myLooper(), (Handler.Callback)this);
        this.mDeviceProfile = new HashMap<UUID, Map<UUID, BluetoothGattCharacteristic>>();
        this.mBluetoothGattResponse = (IBluetoothGattResponse)ProxyUtils.getProxy(this, IBluetoothGattResponse.class, this);
    }

    private void refreshServiceProfile() {
        Logger.v(String.format("refreshServiceProfile for %s", this.mBluetoothDevice.getAddress()));
        List services = this.mBluetoothGatt.getServices();
        HashMap newProfiles = new HashMap();
        for (BluetoothGattService service : services) {
            UUID serviceUUID = service.getUuid();
            HashMap<UUID, BluetoothGattCharacteristic> map = (HashMap<UUID, BluetoothGattCharacteristic>)newProfiles.get(serviceUUID);
            if (map == null) {
                Logger.v("Service: ", serviceUUID);
                map = new HashMap<UUID, BluetoothGattCharacteristic>();
                newProfiles.put(service.getUuid(), map);
            }
            List characters = service.getCharacteristics();
            for (BluetoothGattCharacteristic character : characters) {
                UUID characterUUID = character.getUuid();
                Logger.v("character: uuid = ", characterUUID);
                map.put(character.getUuid(), character);
            }
        }
        this.mDeviceProfile.clear();
        this.mDeviceProfile.putAll(newProfiles);
        this.mBleGattProfile = new BleGattProfile(this.mDeviceProfile);
    }

    private BluetoothGattCharacteristic getCharacter(UUID service, UUID character) {
        BluetoothGattService gattService;
        Map<UUID, BluetoothGattCharacteristic> characters;
        BluetoothGattCharacteristic characteristic = null;
        if (service != null && character != null && (characters = this.mDeviceProfile.get(service)) != null) {
            characteristic = characters.get(character);
        }
        if (characteristic == null && this.mBluetoothGatt != null && (gattService = this.mBluetoothGatt.getService(service)) != null) {
            characteristic = gattService.getCharacteristic(character);
        }
        return characteristic;
    }

    private void setConnectStatus(int status) {
        Logger.v(String.format("setConnectStatus status = %s", Constants.getStatusText(status)));
        this.mConnectStatus = status;
    }

    @Override
    public void onConnectionStateChange(int status, int newState) {
        this.checkRuntime();
        Logger.v(String.format("onConnectionStateChange for %s: status = %d, newState = %d", this.mBluetoothDevice.getAddress(), status, newState));
        if (status == 0 && newState == 2) {
            this.setConnectStatus(2);
            if (this.mGattResponseListener != null) {
                this.mGattResponseListener.onConnectStatusChanged(true);
            }
        } else {
            this.closeGatt();
        }
    }

    @Override
    public void onServicesDiscovered(int status) {
        this.checkRuntime();
        Logger.v(String.format("onServicesDiscovered for %s: status = %d", this.mBluetoothDevice.getAddress(), status));
        if (status == 0) {
            this.setConnectStatus(19);
            this.broadcastConnectStatus(16);
            this.refreshServiceProfile();
        }
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof ServiceDiscoverListener) {
            ((ServiceDiscoverListener)this.mGattResponseListener).onServicesDiscovered(status, this.mBleGattProfile);
        }
    }

    @Override
    public void onCharacteristicRead(BluetoothGattCharacteristic characteristic, int status, byte[] value) {
        this.checkRuntime();
        Logger.v(String.format("onCharacteristicRead for %s: status = %d, service = 0x%s, character = 0x%s, value = %s", this.mBluetoothDevice.getAddress(), status, characteristic.getService().getUuid(), characteristic.getUuid(), ByteUtils.byteToString(value)));
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof ReadCharacterListener) {
            ((ReadCharacterListener)this.mGattResponseListener).onCharacteristicRead(characteristic, status, value);
        }
    }

    @Override
    public void onCharacteristicWrite(BluetoothGattCharacteristic characteristic, int status, byte[] value) {
        this.checkRuntime();
        Logger.v(String.format("onCharacteristicWrite for %s: status = %d, service = 0x%s, character = 0x%s, value = %s", this.mBluetoothDevice.getAddress(), status, characteristic.getService().getUuid(), characteristic.getUuid(), ByteUtils.byteToString(value)));
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof WriteCharacterListener) {
            ((WriteCharacterListener)this.mGattResponseListener).onCharacteristicWrite(characteristic, status, value);
        }
    }

    @Override
    public void onCharacteristicChanged(BluetoothGattCharacteristic characteristic, byte[] value) {
        this.checkRuntime();
        Logger.v(String.format("onCharacteristicChanged for %s: value = %s, service = 0x%s, character = 0x%s", this.mBluetoothDevice.getAddress(), ByteUtils.byteToString(value), characteristic.getService().getUuid(), characteristic.getUuid()));
        this.broadcastCharacterChanged(characteristic.getService().getUuid(), characteristic.getUuid(), value);
    }

    @Override
    public void onDescriptorRead(BluetoothGattDescriptor descriptor, int status, byte[] value) {
        this.checkRuntime();
        Logger.v(String.format("onDescriptorRead for %s: status = %d, service = 0x%s, character = 0x%s, descriptor = 0x%s", this.mBluetoothDevice.getAddress(), status, descriptor.getCharacteristic().getService().getUuid(), descriptor.getCharacteristic().getUuid(), descriptor.getUuid()));
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof ReadDescriptorListener) {
            ((ReadDescriptorListener)this.mGattResponseListener).onDescriptorRead(descriptor, status, value);
        }
    }

    @Override
    public void onDescriptorWrite(BluetoothGattDescriptor descriptor, int status) {
        this.checkRuntime();
        Logger.v(String.format("onDescriptorWrite for %s: status = %d, service = 0x%s, character = 0x%s, descriptor = 0x%s", this.mBluetoothDevice.getAddress(), status, descriptor.getCharacteristic().getService().getUuid(), descriptor.getCharacteristic().getUuid(), descriptor.getUuid()));
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof WriteDescriptorListener) {
            ((WriteDescriptorListener)this.mGattResponseListener).onDescriptorWrite(descriptor, status);
        }
    }

    @Override
    public void onReadRemoteRssi(int rssi, int status) {
        this.checkRuntime();
        Logger.v(String.format("onReadRemoteRssi for %s, rssi = %d, status = %d", this.mBluetoothDevice.getAddress(), rssi, status));
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof ReadRssiListener) {
            ((ReadRssiListener)this.mGattResponseListener).onReadRemoteRssi(rssi, status);
        }
    }

    @Override
    public void onMtuChanged(int mtu, int status) {
        this.checkRuntime();
        Logger.v(String.format("onMtuChanged for %s, mtu = %d, status = %d", this.mBluetoothDevice.getAddress(), mtu, status));
        if (this.mGattResponseListener != null && this.mGattResponseListener instanceof RequestMtuListener) {
            ((RequestMtuListener)this.mGattResponseListener).onMtuChanged(mtu, status);
        }
    }

    private void broadcastConnectStatus(int status) {
        Intent intent = new Intent("action.connect_status_changed");
        intent.putExtra("extra.mac", this.mBluetoothDevice.getAddress());
        intent.putExtra("extra.status", status);
        Utils.sendBroadcast(intent);
    }

    private void broadcastCharacterChanged(UUID service, UUID character, byte[] value) {
        Intent intent = new Intent("action.character_changed");
        intent.putExtra("extra.mac", this.mBluetoothDevice.getAddress());
        intent.putExtra("extra.service.uuid", (Serializable)service);
        intent.putExtra("extra.character.uuid", (Serializable)character);
        intent.putExtra("extra.byte.value", value);
        Utils.sendBroadcast(intent);
    }

    @Override
    public boolean openGatt() {
        this.checkRuntime();
        Logger.v(String.format("openGatt for %s", this.getAddress()));
        if (this.mBluetoothGatt != null) {
            Logger.e(String.format("Previous gatt not closed", new Object[0]));
            return true;
        }
        Context context = Utils.getContext();
        BluetoothGattResponse callback = new BluetoothGattResponse(this.mBluetoothGattResponse);
        this.mBluetoothGatt = Version.isMarshmallow() ? this.mBluetoothDevice.connectGatt(context, false, (BluetoothGattCallback)callback, 2) : this.mBluetoothDevice.connectGatt(context, false, (BluetoothGattCallback)callback);
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("openGatt failed: connectGatt return null!", new Object[0]));
            return false;
        }
        return true;
    }

    private String getAddress() {
        return this.mBluetoothDevice.getAddress();
    }

    @Override
    public void closeGatt() {
        this.checkRuntime();
        Logger.v(String.format("closeGatt for %s", this.getAddress()));
        if (this.mBluetoothGatt != null) {
            this.mBluetoothGatt.close();
            this.mBluetoothGatt = null;
        }
        if (this.mGattResponseListener != null) {
            this.mGattResponseListener.onConnectStatusChanged(false);
        }
        this.setConnectStatus(0);
        this.broadcastConnectStatus(32);
    }

    @Override
    public boolean discoverService() {
        this.checkRuntime();
        Logger.v(String.format("discoverService for %s", this.getAddress()));
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("discoverService but gatt is null!", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.discoverServices()) {
            Logger.e(String.format("discoverServices failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public int getCurrentStatus() {
        this.checkRuntime();
        return this.mConnectStatus;
    }

    @Override
    public void registerGattResponseListener(GattResponseListener listener) {
        this.checkRuntime();
        this.mGattResponseListener = listener;
    }

    @Override
    public void clearGattResponseListener(GattResponseListener listener) {
        this.checkRuntime();
        if (this.mGattResponseListener == listener) {
            this.mGattResponseListener = null;
        }
    }

    @Override
    public boolean refreshDeviceCache() {
        Logger.v(String.format("refreshDeviceCache for %s", this.getAddress()));
        this.checkRuntime();
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!Utils.refreshGattCache(this.mBluetoothGatt)) {
            Logger.e(String.format("refreshDeviceCache failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean readCharacteristic(UUID service, UUID character) {
        Logger.v(String.format("readCharacteristic for %s: service = 0x%s, character = 0x%s", this.mBluetoothDevice.getAddress(), service, character));
        this.checkRuntime();
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.readCharacteristic(characteristic)) {
            Logger.e(String.format("readCharacteristic failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeCharacteristic(UUID service, UUID character, byte[] value) {
        Logger.v(String.format("writeCharacteristic for %s: service = 0x%s, character = 0x%s, value = 0x%s", this.mBluetoothDevice.getAddress(), service, character, ByteUtils.byteToString(value)));
        this.checkRuntime();
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        characteristic.setValue(value != null ? value : ByteUtils.EMPTY_BYTES);
        if (!this.mBluetoothGatt.writeCharacteristic(characteristic)) {
            Logger.e(String.format("writeCharacteristic failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean readDescriptor(UUID service, UUID character, UUID descriptor) {
        Logger.v(String.format("readDescriptor for %s: service = 0x%s, character = 0x%s, descriptor = 0x%s", this.mBluetoothDevice.getAddress(), service, character, descriptor));
        this.checkRuntime();
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        BluetoothGattDescriptor gattDescriptor = characteristic.getDescriptor(descriptor);
        if (gattDescriptor == null) {
            Logger.e(String.format("descriptor not exist", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.readDescriptor(gattDescriptor)) {
            Logger.e(String.format("readDescriptor failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeDescriptor(UUID service, UUID character, UUID descriptor, byte[] value) {
        Logger.v(String.format("writeDescriptor for %s: service = 0x%s, character = 0x%s, descriptor = 0x%s, value = 0x%s", this.mBluetoothDevice.getAddress(), service, character, descriptor, ByteUtils.byteToString(value)));
        this.checkRuntime();
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        BluetoothGattDescriptor gattDescriptor = characteristic.getDescriptor(descriptor);
        if (gattDescriptor == null) {
            Logger.e(String.format("descriptor not exist", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        gattDescriptor.setValue(value != null ? value : ByteUtils.EMPTY_BYTES);
        if (!this.mBluetoothGatt.writeDescriptor(gattDescriptor)) {
            Logger.e(String.format("writeDescriptor failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean writeCharacteristicWithNoRsp(UUID service, UUID character, byte[] value) {
        Logger.v(String.format("writeCharacteristicWithNoRsp for %s: service = 0x%s, character = 0x%s, value = 0x%s", this.mBluetoothDevice.getAddress(), service, character, ByteUtils.byteToString(value)));
        this.checkRuntime();
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        characteristic.setValue(value != null ? value : ByteUtils.EMPTY_BYTES);
        characteristic.setWriteType(1);
        if (!this.mBluetoothGatt.writeCharacteristic(characteristic)) {
            Logger.e(String.format("writeCharacteristic failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean setCharacteristicNotification(UUID service, UUID character, boolean enable) {
        byte[] value;
        this.checkRuntime();
        Logger.v(String.format("setCharacteristicNotification for %s, service = %s, character = %s, enable = %b", this.getAddress(), service, character, enable));
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
            Logger.e(String.format("setCharacteristicNotification failed", new Object[0]));
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(Constants.CLIENT_CHARACTERISTIC_CONFIG);
        if (descriptor == null) {
            Logger.e(String.format("getDescriptor for notify null!", new Object[0]));
            return false;
        }
        byte[] byArray = value = enable ? BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        if (!descriptor.setValue(value)) {
            Logger.e(String.format("setValue for notify descriptor failed!", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.writeDescriptor(descriptor)) {
            Logger.e(String.format("writeDescriptor for notify failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean setCharacteristicIndication(UUID service, UUID character, boolean enable) {
        byte[] value;
        this.checkRuntime();
        Logger.v(String.format("setCharacteristicIndication for %s, service = %s, character = %s, enable = %b", this.getAddress(), service, character, enable));
        BluetoothGattCharacteristic characteristic = this.getCharacter(service, character);
        if (characteristic == null) {
            Logger.e(String.format("characteristic not exist!", new Object[0]));
            return false;
        }
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.setCharacteristicNotification(characteristic, enable)) {
            Logger.e(String.format("setCharacteristicIndication failed", new Object[0]));
            return false;
        }
        BluetoothGattDescriptor descriptor = characteristic.getDescriptor(Constants.CLIENT_CHARACTERISTIC_CONFIG);
        if (descriptor == null) {
            Logger.e(String.format("getDescriptor for indicate null!", new Object[0]));
            return false;
        }
        byte[] byArray = value = enable ? BluetoothGattDescriptor.ENABLE_INDICATION_VALUE : BluetoothGattDescriptor.DISABLE_NOTIFICATION_VALUE;
        if (!descriptor.setValue(value)) {
            Logger.e(String.format("setValue for indicate descriptor failed!", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.writeDescriptor(descriptor)) {
            Logger.e(String.format("writeDescriptor for indicate failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean readRemoteRssi() {
        this.checkRuntime();
        Logger.v(String.format("readRemoteRssi for %s", this.getAddress()));
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.readRemoteRssi()) {
            Logger.e(String.format("readRemoteRssi failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    @TargetApi(value=21)
    public boolean requestMtu(int mtu) {
        this.checkRuntime();
        Logger.v(String.format("requestMtu for %s, mtu = %d", this.getAddress(), mtu));
        if (this.mBluetoothGatt == null) {
            Logger.e(String.format("ble gatt null", new Object[0]));
            return false;
        }
        if (!this.mBluetoothGatt.requestMtu(mtu)) {
            Logger.e(String.format("requestMtu failed", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public BleGattProfile getGattProfile() {
        return this.mBleGattProfile;
    }

    private boolean isCharacteristicReadable(BluetoothGattCharacteristic characteristic) {
        return characteristic != null && (characteristic.getProperties() & 2) != 0;
    }

    private boolean isCharacteristicWritable(BluetoothGattCharacteristic characteristic) {
        return characteristic != null && (characteristic.getProperties() & 8) != 0;
    }

    private boolean isCharacteristicNoRspWritable(BluetoothGattCharacteristic characteristic) {
        return characteristic != null && (characteristic.getProperties() & 4) != 0;
    }

    private boolean isCharacteristicNotifyable(BluetoothGattCharacteristic characteristic) {
        return characteristic != null && (characteristic.getProperties() & 0x10) != 0;
    }

    private boolean isCharacteristicIndicatable(BluetoothGattCharacteristic characteristic) {
        return characteristic != null && (characteristic.getProperties() & 0x20) != 0;
    }

    public boolean handleMessage(Message msg) {
        switch (msg.what) {
            case 288: {
                ProxyBulk.safeInvoke(msg.obj);
            }
        }
        return true;
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] args) {
        this.mWorkerHandler.obtainMessage(288, (Object)new ProxyBulk(object, method, args)).sendToTarget();
        return true;
    }

    @Override
    public void checkRuntime() {
        this.mRuntimeChecker.checkRuntime();
    }
}

