/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.connect;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.proton.bluetooth.connect.BleConnectDispatcher;
import com.proton.bluetooth.connect.IBleConnectMaster;
import com.proton.bluetooth.connect.options.BleConnectOptions;
import com.proton.bluetooth.connect.response.BleGeneralResponse;
import com.proton.bluetooth.utils.proxy.ProxyBulk;
import com.proton.bluetooth.utils.proxy.ProxyInterceptor;
import com.proton.bluetooth.utils.proxy.ProxyUtils;
import java.lang.reflect.Method;
import java.util.UUID;

public class BleConnectMaster
implements IBleConnectMaster,
ProxyInterceptor,
Handler.Callback {
    private Handler mHandler;
    private String mAddress;
    private BleConnectDispatcher mBleConnectDispatcher;

    private BleConnectMaster(String mac, Looper looper) {
        this.mAddress = mac;
        this.mHandler = new Handler(looper, (Handler.Callback)this);
    }

    private BleConnectDispatcher getConnectDispatcher() {
        if (this.mBleConnectDispatcher == null) {
            this.mBleConnectDispatcher = BleConnectDispatcher.newInstance(this.mAddress);
        }
        return this.mBleConnectDispatcher;
    }

    static IBleConnectMaster newInstance(String mac, Looper looper) {
        BleConnectMaster master = new BleConnectMaster(mac, looper);
        return (IBleConnectMaster)ProxyUtils.getProxy(master, IBleConnectMaster.class, master);
    }

    @Override
    public void connect(BleConnectOptions options, BleGeneralResponse response) {
        this.getConnectDispatcher().connect(options, response);
    }

    @Override
    public void disconnect() {
        this.getConnectDispatcher().disconnect();
    }

    @Override
    public void read(UUID service, UUID character, BleGeneralResponse response) {
        this.getConnectDispatcher().read(service, character, response);
    }

    @Override
    public void write(UUID service, UUID character, byte[] bytes, BleGeneralResponse response) {
        this.getConnectDispatcher().write(service, character, bytes, response);
    }

    @Override
    public void writeNoRsp(UUID service, UUID character, byte[] bytes, BleGeneralResponse response) {
        this.getConnectDispatcher().writeNoRsp(service, character, bytes, response);
    }

    @Override
    public void readDescriptor(UUID service, UUID character, UUID descriptor, BleGeneralResponse response) {
        this.getConnectDispatcher().readDescriptor(service, character, descriptor, response);
    }

    @Override
    public void writeDescriptor(UUID service, UUID character, UUID descriptor, byte[] value, BleGeneralResponse response) {
        this.getConnectDispatcher().writeDescriptor(service, character, descriptor, value, response);
    }

    @Override
    public void notify(UUID service, UUID character, BleGeneralResponse response) {
        this.getConnectDispatcher().notify(service, character, response);
    }

    @Override
    public void unnotify(UUID service, UUID character, BleGeneralResponse response) {
        this.getConnectDispatcher().unnotify(service, character, response);
    }

    @Override
    public void readRssi(BleGeneralResponse response) {
        this.getConnectDispatcher().readRemoteRssi(response);
    }

    @Override
    public void indicate(UUID service, UUID character, BleGeneralResponse response) {
        this.getConnectDispatcher().indicate(service, character, response);
    }

    @Override
    public void requestMtu(int mtu, BleGeneralResponse response) {
        this.getConnectDispatcher().requestMtu(mtu, response);
    }

    @Override
    public void clearRequest(int clearType) {
        this.getConnectDispatcher().clearRequest(clearType);
    }

    @Override
    public void refreshCache() {
        this.getConnectDispatcher().refreshCache();
    }

    @Override
    public boolean onIntercept(Object object, Method method, Object[] args) {
        this.mHandler.obtainMessage(0, (Object)new ProxyBulk(object, method, args)).sendToTarget();
        return true;
    }

    public boolean handleMessage(Message msg) {
        ProxyBulk.safeInvoke(msg.obj);
        return true;
    }
}

