/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import com.proton.bluetooth.BluetoothClientImpl;
import com.proton.bluetooth.IBluetoothClient;
import com.proton.bluetooth.connect.listener.BleConnectStatusListener;
import com.proton.bluetooth.connect.listener.BluetoothStateListener;
import com.proton.bluetooth.connect.options.BleConnectOptions;
import com.proton.bluetooth.connect.response.BleConnectResponse;
import com.proton.bluetooth.connect.response.BleMtuResponse;
import com.proton.bluetooth.connect.response.BleNotifyResponse;
import com.proton.bluetooth.connect.response.BleReadResponse;
import com.proton.bluetooth.connect.response.BleReadRssiResponse;
import com.proton.bluetooth.connect.response.BleUnnotifyResponse;
import com.proton.bluetooth.connect.response.BleWriteResponse;
import com.proton.bluetooth.receiver.listener.BluetoothBondListener;
import com.proton.bluetooth.search.SearchRequest;
import com.proton.bluetooth.search.response.SearchResponse;
import com.proton.bluetooth.utils.ByteUtils;
import com.proton.bluetooth.utils.Logger;
import com.proton.bluetooth.utils.Utils;
import com.proton.bluetooth.utils.proxy.ProxyUtils;
import java.util.UUID;

public class BluetoothClient
implements IBluetoothClient {
    private IBluetoothClient mClient;

    public BluetoothClient(Context context) {
        if (context == null) {
            throw new NullPointerException("Context null");
        }
        this.mClient = BluetoothClientImpl.getInstance(context);
    }

    public void connect(String mac, BleConnectResponse response) {
        this.connect(mac, null, response);
    }

    @Override
    public void connect(String mac, BleConnectOptions options, BleConnectResponse response) {
        Logger.v(String.format("connect %s", mac));
        response = (BleConnectResponse)ProxyUtils.getUIProxy(response);
        this.mClient.connect(mac, options, response);
    }

    @Override
    public void disconnect(String mac) {
        Logger.v(String.format("disconnect %s", mac));
        this.mClient.disconnect(mac);
    }

    @Override
    public void read(String mac, UUID service, UUID character, BleReadResponse response) {
        Logger.v(String.format("read character for %s: service = %s, character = %s", mac, service, character));
        response = (BleReadResponse)ProxyUtils.getUIProxy(response);
        this.mClient.read(mac, service, character, response);
    }

    @Override
    public void write(String mac, UUID service, UUID character, byte[] value, BleWriteResponse response) {
        Logger.v(String.format("write character for %s: service = %s, character = %s, value = %s", mac, service, character, ByteUtils.byteToString(value)));
        response = (BleWriteResponse)ProxyUtils.getUIProxy(response);
        this.mClient.write(mac, service, character, value, response);
    }

    @Override
    public void readDescriptor(String mac, UUID service, UUID character, UUID descriptor, BleReadResponse response) {
        Logger.v(String.format("readDescriptor for %s: service = %s, character = %s", mac, service, character));
        response = (BleReadResponse)ProxyUtils.getUIProxy(response);
        this.mClient.readDescriptor(mac, service, character, descriptor, response);
    }

    @Override
    public void writeDescriptor(String mac, UUID service, UUID character, UUID descriptor, byte[] value, BleWriteResponse response) {
        Logger.v(String.format("writeDescriptor for %s: service = %s, character = %s", mac, service, character));
        response = (BleWriteResponse)ProxyUtils.getUIProxy(response);
        this.mClient.writeDescriptor(mac, service, character, descriptor, value, response);
    }

    @Override
    public void writeNoRsp(String mac, UUID service, UUID character, byte[] value, BleWriteResponse response) {
        Logger.v(String.format("writeNoRsp %s: service = %s, character = %s, value = %s", mac, service, character, ByteUtils.byteToString(value)));
        response = (BleWriteResponse)ProxyUtils.getUIProxy(response);
        this.mClient.writeNoRsp(mac, service, character, value, response);
    }

    @Override
    public void notify(String mac, UUID service, UUID character, BleNotifyResponse response) {
        Logger.v(String.format("notify %s: service = %s, character = %s", mac, service, character));
        response = (BleNotifyResponse)ProxyUtils.getUIProxy(response);
        this.mClient.notify(mac, service, character, response);
    }

    @Override
    public void unnotify(String mac, UUID service, UUID character, BleUnnotifyResponse response) {
        Logger.v(String.format("unnotify %s: service = %s, character = %s", mac, service, character));
        response = (BleUnnotifyResponse)ProxyUtils.getUIProxy(response);
        this.mClient.unnotify(mac, service, character, response);
    }

    @Override
    public void indicate(String mac, UUID service, UUID character, BleNotifyResponse response) {
        Logger.v(String.format("indicate %s: service = %s, character = %s", mac, service, character));
        response = (BleNotifyResponse)ProxyUtils.getUIProxy(response);
        this.mClient.indicate(mac, service, character, response);
    }

    @Override
    public void unindicate(String mac, UUID service, UUID character, BleUnnotifyResponse response) {
        Logger.v(String.format("indicate %s: service = %s, character = %s", mac, service, character));
        response = (BleUnnotifyResponse)ProxyUtils.getUIProxy(response);
        this.mClient.unindicate(mac, service, character, response);
    }

    @Override
    public void readRssi(String mac, BleReadRssiResponse response) {
        Logger.v(String.format("readRssi %s", mac));
        response = (BleReadRssiResponse)ProxyUtils.getUIProxy(response);
        this.mClient.readRssi(mac, response);
    }

    @Override
    public void requestMtu(String mac, int mtu, BleMtuResponse response) {
        Logger.v(String.format("requestMtu %s", mac));
        response = (BleMtuResponse)ProxyUtils.getUIProxy(response);
        this.mClient.requestMtu(mac, mtu, response);
    }

    @Override
    public void search(SearchRequest request, SearchResponse response) {
        Logger.v(String.format("search %s", request));
        response = (SearchResponse)ProxyUtils.getUIProxy(response);
        this.mClient.search(request, response);
    }

    @Override
    public void stopSearch() {
        Logger.v(String.format("stopSearch", new Object[0]));
        this.mClient.stopSearch();
    }

    @Override
    public void registerConnectStatusListener(String mac, BleConnectStatusListener listener) {
        this.mClient.registerConnectStatusListener(mac, listener);
    }

    @Override
    public void unregisterConnectStatusListener(String mac, BleConnectStatusListener listener) {
        this.mClient.unregisterConnectStatusListener(mac, listener);
    }

    @Override
    public void registerBluetoothStateListener(BluetoothStateListener listener) {
        this.mClient.registerBluetoothStateListener(listener);
    }

    @Override
    public void unregisterBluetoothStateListener(BluetoothStateListener listener) {
        this.mClient.unregisterBluetoothStateListener(listener);
    }

    @Override
    public void registerBluetoothBondListener(BluetoothBondListener listener) {
        this.mClient.registerBluetoothBondListener(listener);
    }

    @Override
    public void unregisterBluetoothBondListener(BluetoothBondListener listener) {
        this.mClient.unregisterBluetoothBondListener(listener);
    }

    public int getConnectStatus(String mac) {
        return Utils.getConnectStatus(mac);
    }

    public BluetoothDevice getDevice(String mac) {
        return Utils.getDevice(mac);
    }

    public boolean isBluetoothOpened() {
        return Utils.isBluetoothEnabled();
    }

    public boolean openBluetooth() {
        return Utils.openBluetooth();
    }

    public boolean closeBluetooth() {
        return Utils.closeBluetooth();
    }

    public boolean isBleSupported() {
        return Utils.isBleSupported();
    }

    public int getBondState(String mac) {
        return Utils.getBondState(mac);
    }

    @Override
    public void clearRequest(String mac, int type) {
        this.mClient.clearRequest(mac, type);
    }

    @Override
    public void refreshCache(String mac) {
        this.mClient.refreshCache(mac);
    }
}

