/*
 * Decompiled with CFR 0.152.
 */
package com.proton.bluetooth.utils;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.proton.bluetooth.BluetoothContext;
import com.proton.bluetooth.utils.Logger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class Utils {
    private static BluetoothManager mBluetoothManager;
    private static BluetoothAdapter mBluetoothAdapter;
    private static Handler mHandler;

    public static Context getContext() {
        return BluetoothContext.get();
    }

    private static Handler getHandler() {
        if (mHandler == null) {
            mHandler = new Handler(Looper.getMainLooper());
        }
        return mHandler;
    }

    public static void post(Runnable runnable) {
        Utils.getHandler().post(runnable);
    }

    public static void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        Utils.registerGlobalReceiver(receiver, filter);
    }

    private static void registerGlobalReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        Utils.getContext().registerReceiver(receiver, filter);
    }

    public static void unregisterReceiver(BroadcastReceiver receiver) {
        Utils.unregisterGlobalReceiver(receiver);
    }

    private static void unregisterGlobalReceiver(BroadcastReceiver receiver) {
        Utils.getContext().unregisterReceiver(receiver);
    }

    public static void sendBroadcast(Intent intent) {
        Utils.sendGlobalBroadcast(intent);
    }

    public static void sendBroadcast(String action) {
        Utils.sendGlobalBroadcast(new Intent(action));
    }

    private static void sendGlobalBroadcast(Intent intent) {
        Utils.getContext().sendBroadcast(intent);
    }

    public static boolean isBleSupported() {
        return Build.VERSION.SDK_INT >= 18 && Utils.getContext() != null && Utils.getContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public static boolean isBluetoothEnabled() {
        return Utils.getBluetoothState() == 12;
    }

    public static int getBluetoothState() {
        BluetoothAdapter adapter = Utils.getBluetoothAdapter();
        return adapter != null ? adapter.getState() : 0;
    }

    public static boolean openBluetooth() {
        BluetoothAdapter adapter = Utils.getBluetoothAdapter();
        if (adapter != null) {
            return adapter.enable();
        }
        return false;
    }

    public static boolean closeBluetooth() {
        BluetoothAdapter adapter = Utils.getBluetoothAdapter();
        if (adapter != null) {
            return adapter.disable();
        }
        return false;
    }

    public static BluetoothManager getBluetoothManager() {
        if (Utils.isBleSupported()) {
            if (mBluetoothManager == null) {
                mBluetoothManager = (BluetoothManager)Utils.getContext().getSystemService("bluetooth");
            }
            return mBluetoothManager;
        }
        return null;
    }

    public static BluetoothAdapter getBluetoothAdapter() {
        if (mBluetoothAdapter == null) {
            mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        }
        return mBluetoothAdapter;
    }

    public static BluetoothDevice getRemoteDevice(String mac) {
        BluetoothAdapter adapter;
        if (!TextUtils.isEmpty((CharSequence)mac) && (adapter = Utils.getBluetoothAdapter()) != null) {
            return adapter.getRemoteDevice(mac);
        }
        return null;
    }

    @TargetApi(value=18)
    public static List<BluetoothDevice> getConnectedBluetoothLeDevices() {
        ArrayList<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        BluetoothManager manager = Utils.getBluetoothManager();
        if (manager != null) {
            devices.addAll(manager.getConnectedDevices(7));
        }
        return devices;
    }

    @TargetApi(value=18)
    public static int getConnectStatus(String mac) {
        BluetoothManager manager = Utils.getBluetoothManager();
        if (manager != null) {
            try {
                BluetoothDevice device = Utils.getRemoteDevice(mac);
                return manager.getConnectionState(device, 7);
            }
            catch (Throwable e) {
                Logger.e(e);
            }
        }
        return -1;
    }

    public static int getBondState(String mac) {
        BluetoothManager manager = Utils.getBluetoothManager();
        if (manager != null) {
            try {
                BluetoothDevice device = Utils.getRemoteDevice(mac);
                return device.getBondState();
            }
            catch (Throwable e) {
                Logger.e(e);
            }
        }
        return 10;
    }

    public static List<BluetoothDevice> getBondedBluetoothClassicDevices() {
        Set sets;
        BluetoothAdapter adapter = Utils.getBluetoothAdapter();
        ArrayList<BluetoothDevice> devices = new ArrayList<BluetoothDevice>();
        if (adapter != null && (sets = adapter.getBondedDevices()) != null) {
            devices.addAll(sets);
        }
        return devices;
    }

    @TargetApi(value=18)
    public static boolean isDeviceConnected(String mac) {
        if (!TextUtils.isEmpty((CharSequence)mac) && Utils.isBleSupported()) {
            BluetoothDevice device = Utils.getBluetoothAdapter().getRemoteDevice(mac);
            return Utils.getBluetoothManager().getConnectionState(device, 7) == 2;
        }
        return false;
    }

    public static boolean checkMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static boolean refreshGattCache(BluetoothGatt gatt) {
        boolean result = false;
        try {
            Method refresh;
            if (gatt != null && (refresh = BluetoothGatt.class.getMethod("refresh", new Class[0])) != null) {
                refresh.setAccessible(true);
                result = (Boolean)refresh.invoke((Object)gatt, new Object[0]);
            }
        }
        catch (Exception e) {
            Logger.e(e);
        }
        Logger.v(String.format("refreshDeviceCache return %b", result));
        return result;
    }
}

